/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.properties.ConfigurationHandler;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

public class TypedProperties
extends AbstractMap<String, Object> {
    public static final String ENV_PREFIX = "env:";
    private final SubstitutionCallback _callback;
    private final Properties _storage = new Properties(false);
    private final boolean _substitute;

    public static Map<String, Map<String, String>> prepare(Map<String, TypedProperties> properties) {
        HashMap<String, Map<String, String>> dynamic = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, TypedProperties> entry : properties.entrySet()) {
            String name = entry.getKey();
            TypedProperties typedProperties = entry.getValue();
            dynamic.put(name, new DynamicMap(name, typedProperties._storage));
        }
        return dynamic;
    }

    public static void substitute(Map<String, TypedProperties> properties, Map<String, Map<String, String>> dynamic, SubstitutionCallback callback, boolean finalSubstitution) {
        for (Map<String, String> map : dynamic.values()) {
            DynamicMap dynamicMap = (DynamicMap)map;
            dynamicMap.init(callback, finalSubstitution);
        }
        for (Map.Entry entry : properties.entrySet()) {
            TypedProperties typedProperties = (TypedProperties)entry.getValue();
            typedProperties._storage.putAllSubstituted(dynamic.get(entry.getKey()));
        }
    }

    public TypedProperties() {
        this(null, true);
    }

    public TypedProperties(boolean substitute) {
        this(null, substitute);
    }

    public TypedProperties(SubstitutionCallback callback) {
        this(callback, true);
    }

    public TypedProperties(SubstitutionCallback callback, boolean substitute) {
        this._callback = callback;
        this._substitute = substitute;
    }

    @Override
    public void clear() {
        this._storage.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return TypedProperties.this._storage.size();
            }
        };
    }

    @Override
    public Object get(Object key) {
        String value = (String)this._storage.get(key);
        if (value != null && this._storage.isTyped()) {
            return TypedProperties._convertFromString(value);
        }
        return value;
    }

    public List<String> getComments(String key) {
        return this._storage.getComments(key);
    }

    public List<String> getFooter() {
        return this._storage.getFooter();
    }

    public List<String> getHeader() {
        return this._storage.getHeader();
    }

    public List<String> getRaw(String key) {
        return this._storage.getRaw(key);
    }

    public void load(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.load(inputStream);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");){
            this.load(inputStreamReader);
        }
    }

    public void load(Reader reader) throws IOException {
        this._storage.loadLayout(reader, true);
        this.substitute(this._callback);
    }

    public void load(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            this.load(inputStream);
        }
    }

    public Object put(String key, List<String> commentLines, List<String> valueLines) {
        String old = this._storage.put(key, commentLines, valueLines);
        if (old == null) {
            return null;
        }
        if (this._storage.isTyped()) {
            return TypedProperties._convertFromString(old);
        }
        return old;
    }

    public Object put(String key, List<String> commentLines, Object value) {
        if (value instanceof String && !this._storage.isTyped()) {
            return this._storage.put(key, commentLines, (String)value);
        }
        this._ensureTyped();
        String string = TypedProperties._convertToString(value);
        return this.put(key, commentLines, Arrays.asList(string.split("\n")));
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof String && !this._storage.isTyped()) {
            return this._storage.put(key, (String)value);
        }
        this._ensureTyped();
        String old = this._storage.put(key, TypedProperties._convertToString(value));
        if (old == null) {
            return null;
        }
        return TypedProperties._convertFromString(old);
    }

    public Object put(String key, String comment, Object value) {
        return this.put(key, Collections.singletonList(comment), value);
    }

    @Override
    public Object remove(Object key) {
        return this._storage.remove(key);
    }

    public void save(File location) throws IOException {
        this._storage.save(location);
    }

    public void save(OutputStream outputStream) throws IOException {
        this._storage.save(outputStream);
    }

    public void save(Writer writer) throws IOException {
        this._storage.save(writer);
    }

    public void setFooter(List<String> footer) {
        this._storage.setFooter(footer);
    }

    public void setHeader(List<String> header) {
        this._storage.setHeader(header);
    }

    public void store(OutputStream outputStream, String comment) throws IOException {
        this._storage.store(outputStream, comment);
    }

    public void substitute(SubstitutionCallback substitutionCallback) {
        if (!this._substitute) {
            return;
        }
        SubstitutionCallback callback = substitutionCallback;
        if (callback == null) {
            callback = new SubstitutionCallback(){

                @Override
                public String getValue(String name, String key, String value) {
                    if (value.startsWith(TypedProperties.ENV_PREFIX)) {
                        return System.getenv(value.substring(TypedProperties.ENV_PREFIX.length()));
                    }
                    return System.getProperty(value);
                }
            };
        }
        Map<String, TypedProperties> map = Collections.singletonMap("root", this);
        TypedProperties.substitute(map, TypedProperties.prepare(map), callback, true);
    }

    public boolean update(Map<String, Object> map) {
        TypedProperties typedProperties = new TypedProperties();
        if (map instanceof TypedProperties) {
            typedProperties = (TypedProperties)map;
        } else {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                typedProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return this.update(typedProperties);
    }

    public boolean update(TypedProperties properties) {
        return this._storage.update(properties._storage);
    }

    private static Object _convertFromString(String value) {
        try {
            return ConfigurationHandler.read(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static String _convertToString(Object value) {
        try {
            return ConfigurationHandler.write(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static SubstitutionCallback _wrap(final InterpolationHelper.SubstitutionCallback cb) {
        return new SubstitutionCallback(){

            @Override
            public String getValue(String name, String key, String value) {
                return cb.getValue(value);
            }
        };
    }

    private void _ensureTyped() {
        if (!this._storage.isTyped()) {
            this._storage.setTyped(true);
            HashSet keys = new HashSet(this._storage.keySet());
            for (String key : keys) {
                String string = TypedProperties._convertToString(this._storage.get(key));
                this._storage.put(key, this._storage.getComments(key), Arrays.asList(string.split("\n")));
            }
        }
    }

    private class KeyIterator
    implements Iterator {
        private final Iterator<String> _iterator;

        public KeyIterator() {
            Set entries = TypedProperties.this._storage.keySet();
            this._iterator = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Map.Entry<String, Object> next() {
            final String key = this._iterator.next();
            return new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return TypedProperties.this.get(key);
                }

                @Override
                public Object setValue(Object value) {
                    return TypedProperties.this.put(key, value);
                }
            };
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private static class DynamicMap
    extends AbstractMap<String, String> {
        private SubstitutionCallback _callback;
        private final Map<String, String> _computed = new HashMap<String, String>();
        private final Map<String, String> _cycles = new HashMap<String, String>();
        private boolean _finalSubstitution;
        private final String _name;
        private final Properties _storage;

        public DynamicMap(String name, Properties storage) {
            this._name = name;
            this._storage = storage;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    Set keys = _storage.keySet();
                    return new ComputedIterator(keys.iterator());
                }

                @Override
                public int size() {
                    return _storage.size();
                }
            };
        }

        public void init(SubstitutionCallback callback, boolean finalSubstitution) {
            this._callback = callback;
            this._finalSubstitution = finalSubstitution;
        }

        private String _compute(final String key) {
            InterpolationHelper.SubstitutionCallback wrapper = new InterpolationHelper.SubstitutionCallback(){

                @Override
                public String getValue(String value) {
                    String string = (String)this.get(value);
                    if (!_finalSubstitution || string == null) {
                        return _callback.getValue(_name, key, value);
                    }
                    if (!_storage.isTyped()) {
                        return string;
                    }
                    boolean mult = false;
                    boolean hasType = false;
                    char t = string.charAt(0);
                    if (t == '[' || t == '(') {
                        mult = true;
                    } else {
                        t = string.charAt(1);
                        if (t == '[' || t == '(') {
                            mult = true;
                        }
                        hasType = true;
                    }
                    if (mult) {
                        throw new IllegalArgumentException("Cannot substitute from a collection/array value: " + value);
                    }
                    if (hasType) {
                        return (String)TypedProperties._convertFromString(string.substring(1));
                    }
                    return (String)TypedProperties._convertFromString(string);
                }
            };
            String value = (String)this._storage.get(key);
            return InterpolationHelper.substVars(value, key, this._cycles, this, wrapper, false, this._finalSubstitution, this._finalSubstitution);
        }

        private class ComputedIterator
        implements Iterator<Map.Entry<String, String>> {
            private final Iterator<String> _iterator;

            public ComputedIterator(Iterator<String> iterator) {
                this._iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this._iterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final String key = this._iterator.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public String getValue() {
                        String v = (String)DynamicMap.this._computed.get(key);
                        if (v == null) {
                            v = DynamicMap.this._compute(key);
                        }
                        return v;
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface SubstitutionCallback {
        public String getValue(String var1, String var2, String var3);
    }
}

