/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import java.util.ArrayList;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;

public final class Parser {
    private static final int _CHAR = 1;
    private static final int _DELIMITER = 2;
    private static final int _ENDQUOTE = 8;
    private static final int _STARTQUOTE = 4;

    public static Clause[] parseClauses(String[] clauses) throws IllegalArgumentException {
        if (clauses == null) {
            return null;
        }
        ArrayList<Clause> completeList = new ArrayList<Clause>();
        for (String clause : clauses) {
            String[] tokens = Parser.parseDelimitedString(clause, ";");
            int pathCount = 0;
            for (String token : tokens) {
                if (token.indexOf(61) != -1) break;
                ++pathCount;
            }
            if (pathCount == 0) {
                throw new IllegalArgumentException("No path specified on clause: " + clause);
            }
            int size = tokens.length - pathCount;
            Directive[] directives = new Directive[size];
            Attribute[] attributes = new Attribute[size];
            int directiveCount = 0;
            int attributeCount = 0;
            int index = -1;
            String separator = null;
            for (int pieceIndex = pathCount; pieceIndex < tokens.length; ++pieceIndex) {
                String piece = tokens[pieceIndex];
                index = piece.indexOf("=");
                if (index <= 0) {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clause);
                }
                if (piece.charAt(index - 1) == ':') {
                    --index;
                    separator = ":=";
                } else {
                    separator = "=";
                }
                String key = piece.substring(0, index);
                key = key.trim();
                String value = piece.substring(index + separator.length());
                value = value.trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (separator.equals(":=")) {
                    directives[directiveCount++] = new Directive(key, value);
                    continue;
                }
                attributes[attributeCount++] = new Attribute(key, value);
            }
            Directive[] dirsFinal = new Directive[directiveCount];
            System.arraycopy(directives, 0, dirsFinal, 0, directiveCount);
            Attribute[] attrsFinal = new Attribute[attributeCount];
            System.arraycopy(attributes, 0, attrsFinal, 0, attributeCount);
            Clause[] packages = new Clause[pathCount];
            for (int packageIndex = 0; packageIndex < pathCount; ++packageIndex) {
                packages[packageIndex] = new Clause(tokens[packageIndex], dirsFinal, attrsFinal);
                completeList.add(packages[packageIndex]);
            }
        }
        return completeList.toArray(new Clause[0]);
    }

    public static String[] parseDelimitedString(String value, String delimiter) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int expecting = 7;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (delimiter.indexOf(c) != -1 && (expecting & 2) > 0) {
                String string = sb.toString();
                list.add(string.trim());
                sb.delete(0, sb.length());
                expecting = 7;
                continue;
            }
            if (c == '\"' && (expecting & 4) > 0) {
                sb.append(c);
                expecting = 9;
                continue;
            }
            if (c == '\"' && (expecting & 8) > 0) {
                sb.append(c);
                expecting = 7;
                continue;
            }
            if ((expecting & 1) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        String string = sb.toString();
        if ((string = string.trim()).length() > 0) {
            list.add(string);
        }
        return list.toArray(new String[0]);
    }

    public static Clause[] parseHeader(String header) throws IllegalArgumentException {
        Clause[] clauses = null;
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("The header cannot be an empty string");
            }
            String[] headers = Parser.parseDelimitedString(header, ",");
            clauses = Parser.parseClauses(headers);
        }
        if (clauses == null) {
            return new Clause[0];
        }
        return clauses;
    }
}

