/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.version;

import java.io.Serializable;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public class VersionRange
implements Serializable {
    public static final int ANY = 40;
    public static final VersionRange ANY_VERSION;
    public static final int EXACT = 0;
    public static final Version INFINITE_VERSION;
    public static final int MAJOR = 3;
    public static final int MICRO = 1;
    public static final int MINOR = 2;
    private static boolean[] _removeable;
    private static final long serialVersionUID = 1L;
    private final Version _ceiling;
    private final Version _floor;
    private final boolean _openCeiling;
    private final boolean _openFloor;

    public static VersionRange newInstance(Version pointVersion, int lowerBoundRule, int upperBoundRule) {
        Version floor = null;
        if (lowerBoundRule == 40) {
            floor = VersionTable.getVersion(0, 0, 0);
        } else if (lowerBoundRule == 3) {
            floor = VersionTable.getVersion(pointVersion.getMajor(), 0, 0);
        } else if (lowerBoundRule == 2) {
            floor = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), 0);
        } else if (lowerBoundRule == 1) {
            floor = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), pointVersion.getMicro());
        } else if (lowerBoundRule == 0) {
            floor = pointVersion;
        }
        Version ceiling = null;
        boolean openCeiling = true;
        if (upperBoundRule == 40) {
            ceiling = INFINITE_VERSION;
        } else if (upperBoundRule == 3) {
            ceiling = VersionTable.getVersion(pointVersion.getMajor() + 1, 0, 0);
        } else if (upperBoundRule == 2) {
            ceiling = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor() + 1, 0);
        } else if (upperBoundRule == 1) {
            ceiling = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), pointVersion.getMicro() + 1);
        } else if (upperBoundRule == 0) {
            ceiling = pointVersion;
            openCeiling = false;
        }
        return new VersionRange(false, floor, ceiling, openCeiling);
    }

    public static VersionRange parseVersionRange(String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            return ANY_VERSION;
        }
        if ((string = string.trim()).length() == 0) {
            return ANY_VERSION;
        }
        return new VersionRange(string);
    }

    public VersionRange(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        this._openFloor = openFloor;
        this._floor = floor;
        this._ceiling = ceiling;
        this._openCeiling = openCeiling;
        this._checkRange();
    }

    public VersionRange(String value) throws IllegalArgumentException, NumberFormatException {
        this(value, false);
    }

    public VersionRange(String value, boolean exact) throws IllegalArgumentException, NumberFormatException {
        this(value, exact, true);
    }

    public VersionRange(String value, boolean exact, boolean clean) throws IllegalArgumentException, NumberFormatException {
        value = this._removeQuotesAndWhitespaces(value);
        char first = value.charAt(0);
        if (first == '[') {
            this._openFloor = false;
        } else if (first == '(') {
            this._openFloor = true;
        } else {
            this._openFloor = false;
            this._floor = VersionTable.getVersion(value, clean);
            if (exact) {
                this._ceiling = this._floor;
                this._openCeiling = false;
            } else {
                this._ceiling = INFINITE_VERSION;
                this._openCeiling = true;
            }
            return;
        }
        char last = value.charAt(value.length() - 1);
        if (last == ']') {
            this._openCeiling = false;
        } else if (last == ')') {
            this._openCeiling = true;
        } else {
            throw new IllegalArgumentException("Illegal version range syntax " + value + ": range must end in ')' or ']'");
        }
        int comma = value.indexOf(44);
        if (comma == -1) {
            throw new IllegalArgumentException("Illegal version range syntax no comma");
        }
        if (value.indexOf(44, comma + 1) > 0) {
            throw new IllegalArgumentException("Illegal version range syntax too many commas");
        }
        String floor = value.substring(1, comma);
        String ceiling = value.substring(comma + 1, value.length() - 1);
        this._floor = VersionTable.getVersion(floor, clean);
        this._ceiling = ceiling.equals("*") ? INFINITE_VERSION : VersionTable.getVersion(ceiling, clean);
        this._checkRange();
    }

    public VersionRange(Version atLeast) {
        this(atLeast, false);
    }

    public VersionRange(Version atLeast, boolean exact) {
        this._openFloor = false;
        this._floor = atLeast;
        this._ceiling = exact ? atLeast : INFINITE_VERSION;
        this._openCeiling = !exact;
        this._checkRange();
    }

    public boolean contains(Version version) {
        if (version.equals((Object)INFINITE_VERSION)) {
            return this._ceiling.equals((Object)INFINITE_VERSION);
        }
        return version.compareTo(this._floor) > 0 && version.compareTo(this._ceiling) < 0 || !this._openFloor && version.equals((Object)this._floor) || !this._openCeiling && version.equals((Object)this._ceiling);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        Version ceiling = versionRange.getCeiling();
        if (this._ceiling == null ? ceiling != null : !this._ceiling.equals((Object)ceiling)) {
            return false;
        }
        Version floor = versionRange.getFloor();
        if (this._floor == null ? floor != null : !this._floor.equals((Object)floor)) {
            return false;
        }
        if (this._openCeiling != versionRange.isOpenCeiling()) {
            return false;
        }
        return this._openFloor == versionRange.isOpenFloor();
    }

    public Version getCeiling() {
        return this._ceiling;
    }

    public Version getFloor() {
        return this._floor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = this._ceiling == null ? prime * result : prime * result + this._ceiling.hashCode();
        result = this._floor == null ? prime * result : prime * result + this._floor.hashCode();
        result = this._openCeiling ? prime * result + 1231 : prime * result + 1237;
        result = this._openFloor ? prime * result + 1231 : prime * result + 1237;
        return result;
    }

    public VersionRange intersect(VersionRange versionRange) {
        Version newFloor = null;
        boolean newOpenFloor = false;
        int minCompare = this._floor.compareTo(versionRange.getFloor());
        if (minCompare > 0) {
            newFloor = this._floor;
            newOpenFloor = this._openFloor;
        } else if (minCompare < 0) {
            newFloor = versionRange.getFloor();
            newOpenFloor = versionRange.isOpenFloor();
        } else {
            newFloor = this._floor;
            newOpenFloor = this._openFloor || versionRange.isOpenFloor();
        }
        Version newCeiling = null;
        boolean newOpenCeiling = false;
        int maxCompare = this._ceiling.compareTo(versionRange.getCeiling());
        if (maxCompare < 0) {
            newCeiling = this._ceiling;
            newOpenCeiling = this._openCeiling;
        } else if (maxCompare > 0) {
            newCeiling = versionRange.getCeiling();
            newOpenCeiling = versionRange.isOpenCeiling();
        } else {
            newCeiling = this._ceiling;
            newOpenCeiling = this._openCeiling || versionRange.isOpenCeiling();
        }
        VersionRange result = null;
        if (VersionRange._isRangeValid(newOpenFloor, newFloor, newCeiling, newOpenCeiling)) {
            result = new VersionRange(newOpenFloor, newFloor, newCeiling, newOpenCeiling);
        }
        return result;
    }

    public boolean isOpenCeiling() {
        return this._openCeiling;
    }

    public boolean isOpenFloor() {
        return this._openFloor;
    }

    public boolean isPointVersion() {
        return !this._openFloor && !this._openCeiling && this._floor.equals((Object)this._ceiling);
    }

    public String toString() {
        if (ANY_VERSION.equals(this)) {
            return this._makeString(this._openFloor, Version.emptyVersion, INFINITE_VERSION, this._openCeiling);
        }
        return this._makeString(this._openFloor, this._floor, this._ceiling, this._openCeiling);
    }

    private static boolean _isRangeValid(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        boolean result = false;
        int compare = floor.compareTo(ceiling);
        result = compare > 0 ? false : compare != 0 || !openFloor && !openCeiling;
        return result;
    }

    private void _checkRange() {
        if (!VersionRange._isRangeValid(this._openFloor, this._floor, this._ceiling, this._openCeiling)) {
            throw new IllegalArgumentException("Invalid version range: " + this._makeString(this._openFloor, this._floor, this._ceiling, this._openCeiling));
        }
    }

    private boolean _isRemoveable(char c) {
        if (c < '\u0100') {
            return _removeable[c];
        }
        return Character.isWhitespace(c);
    }

    private String _makeString(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        StringBuffer sb = new StringBuffer(32);
        if (INFINITE_VERSION.equals((Object)ceiling)) {
            if (Version.emptyVersion.equals((Object)floor)) {
                sb.append("0");
            } else {
                sb.append(floor.toString());
            }
        } else {
            if (openFloor) {
                sb.append("(");
            } else {
                sb.append("[");
            }
            if (Version.emptyVersion.equals((Object)floor)) {
                sb.append("0");
            } else {
                sb.append(floor.toString());
            }
            sb.append(",");
            if (openCeiling) {
                sb.append(")");
            } else {
                sb.append("]");
            }
        }
        return sb.toString();
    }

    private String _removeQuotesAndWhitespaces(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (!this._isRemoveable(c)) continue;
            StringBuilder sb = new StringBuilder(length);
            sb.append(value, 0, i);
            ++i;
            while (i < length) {
                c = value.charAt(i);
                if (!this._isRemoveable(c)) {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return value;
    }

    static {
        _removeable = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            VersionRange._removeable[i] = Character.isWhitespace(i);
        }
        VersionRange._removeable[34] = true;
        INFINITE_VERSION = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "");
        ANY_VERSION = new VersionRange(false, Version.emptyVersion, INFINITE_VERSION, true);
    }
}

