/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DictionaryAsMap<K, V>
extends AbstractMap<K, V> {
    private final Dictionary<K, V> _dictionary;

    public DictionaryAsMap(Dictionary<K, V> dictionary) {
        this._dictionary = dictionary;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Enumeration enumeration = DictionaryAsMap.this._dictionary.keys();
                return new Iterator<Map.Entry<K, V>>(){
                    private K _key;

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this._key = enumeration.nextElement();
                        return new KeyEntry(this._key);
                    }

                    @Override
                    public void remove() {
                        if (this._key == null) {
                            throw new IllegalStateException();
                        }
                        DictionaryAsMap.this._dictionary.remove(this._key);
                    }
                };
            }

            @Override
            public int size() {
                return DictionaryAsMap.this._dictionary.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        return this._dictionary.put(key, value);
    }

    private class KeyEntry
    implements Map.Entry<K, V> {
        private final K _key;

        public KeyEntry(K key) {
            this._key = key;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return DictionaryAsMap.this._dictionary.get(this._key);
        }

        @Override
        public V setValue(V value) {
            return DictionaryAsMap.this.put(this._key, value);
        }
    }
}

