/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.weld;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.cdi.spi.loader.SpiLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BundleResourcesLoader
implements ProxyServices,
ResourceLoader {
    private static Method defineClass1;
    private static Method defineClass2;
    private static final AtomicBoolean classLoaderMethodsMadeAccessible;
    private static final String ERROR_LOADING_CLASS = "Error loading class ";
    private final ClassLoader _classLoader;

    public static void makeClassLoaderMethodsAccessible() {
        if (classLoaderMethodsMadeAccessible.compareAndSet(false, true)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Class<?> cl = Class.forName("java.lang.ClassLoader");
                        String name = "defineClass";
                        defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                        defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                        defineClass1.setAccessible(true);
                        defineClass2.setAccessible(true);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException("cannot initialize ClassPool", pae.getException());
            }
        }
    }

    BundleResourcesLoader(SpiLoader loader, Bundle spiImplBundle) {
        BundleWiring spiImplWiring = (BundleWiring)spiImplBundle.adapt(BundleWiring.class);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(spiImplBundle);
        List requiredWires = spiImplWiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire bundleWire : requiredWires) {
            Bundle wireBundle;
            BundleCapability capability = bundleWire.getCapability();
            Map attributes = capability.getAttributes();
            String packageName = (String)attributes.get("osgi.wiring.package");
            if (!packageName.startsWith("org.jboss.weld.") || bundles.contains(wireBundle = bundleWire.getProvider().getBundle())) continue;
            bundles.add(wireBundle);
        }
        loader.getBundles().addAll(bundles);
        this._classLoader = loader;
    }

    public void cleanup() {
    }

    public Class<?> classForName(String className) {
        try {
            return this._classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        try {
            Object[] args;
            Method method;
            if (protectionDomain == null) {
                method = defineClass1;
                args = new Object[]{className, classBytes, 0, len};
            } else {
                method = defineClass2;
                args = new Object[]{className, classBytes, 0, len, protectionDomain};
            }
            Class clazz = (Class)method.invoke((Object)this._classLoader, args);
            return clazz;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        return this._classLoader;
    }

    public Class<?> loadBeanClass(String className) {
        return this.classForName(className);
    }

    public URL getResource(String name) {
        return this._classLoader.getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            return Collections.list(this._classLoader.getResources(name));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Class<?> loadClass(Class<?> originalClass, String className) throws ClassNotFoundException {
        return this._classLoader.loadClass(className);
    }

    public boolean supportsClassDefining() {
        return true;
    }

    static {
        classLoaderMethodsMadeAccessible = new AtomicBoolean(false);
        BundleResourcesLoader.makeClassLoaderMethodsAccessible();
    }
}

