/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import org.apache.aries.cdi.container.internal.container.ContainerBootstrap;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.model.InstanceActivator;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.osgi.service.log.Logger;

public class ContainerActivator
extends InstanceActivator {
    private final Syncro syncro = new Syncro(true);
    private final Logger _log = this.containerState.containerLogs().getLogger(this.getClass());

    private ContainerActivator(Builder builder) {
        super(builder);
    }

    @Override
    public boolean close() {
        try (Syncro open = this.syncro.open();){
            boolean result = this.next.map(next -> {
                this.submit(next.closeOp(), next::close).onFailure(f -> this._log.error(l -> l.error("CCR Failure in container activator close on {}", next, f)));
                return true;
            }).orElse(true);
            this._instance.active = false;
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.CONTAINER_ACTIVATOR, this._instance.template.name);
    }

    @Override
    public boolean open() {
        try (Syncro open = this.syncro.open();){
            if (!this._instance.referencesResolved()) {
                boolean bl = false;
                return bl;
            }
            boolean result = this.next.map(next -> {
                this.submit(next.openOp(), next::open).onFailure(f -> {
                    this._log.error(l -> l.error("CCR Failure in container activator open on {}", next, f));
                    this.containerState.error((Throwable)f);
                });
                return true;
            }).orElse(true);
            if (result) {
                this._instance.active = true;
            }
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.CONTAINER_ACTIVATOR, this._instance.template.name);
    }

    public static class Builder
    extends InstanceActivator.Builder<Builder> {
        public Builder(ContainerState containerState, ContainerBootstrap next) {
            super(containerState, next);
        }

        @Override
        public ContainerActivator build() {
            return new ContainerActivator(this);
        }
    }
}

