/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Reflection;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.annotations.PID;

public class ComponentPropertiesModel {
    private final Class<?> _beanClass;
    private final Class<?> _declaringClass;
    private final PID _pid;
    private final Set<Annotation> _qualifiers;
    private volatile String _string;
    private final Type _injectionPointType;

    private ComponentPropertiesModel(Type injectionPointType, Class<?> delcaringClass, PID pid, Set<Annotation> qualifiers) {
        this._injectionPointType = injectionPointType;
        this._pid = pid;
        this._qualifiers = new LinkedHashSet<Annotation>();
        this._declaringClass = delcaringClass;
        if (qualifiers != null) {
            this._qualifiers.addAll(qualifiers);
        }
        Type rawType = injectionPointType;
        if (this._injectionPointType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this._injectionPointType;
            rawType = pt.getRawType();
        }
        this._beanClass = (Class)Reflection.cast(rawType);
    }

    public PID getPid() {
        return this._pid;
    }

    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    public Type getType() {
        return this._injectionPointType;
    }

    public ExtendedConfigurationTemplateDTO toDTO() {
        ExtendedConfigurationTemplateDTO dto = new ExtendedConfigurationTemplateDTO();
        dto.beanClass = this._beanClass;
        dto.declaringClass = this._declaringClass;
        dto.injectionPointType = this._injectionPointType;
        dto.maximumCardinality = MaximumCardinality.ONE;
        if (this._pid != null) {
            dto.pid = this._pid.value();
        }
        dto.policy = this._pid != null ? this._pid.policy() : ConfigurationPolicy.OPTIONAL;
        return dto;
    }

    public String toString() {
        if (this._string == null) {
            this._string = String.format("configuration[type='%s', pid='%s', policy='%s']", this._injectionPointType, this._pid.value(), this._pid.policy());
        }
        return this._string;
    }

    public static class Builder {
        private Class<?> _delcaringClass;
        private PID _pid;
        private Set<Annotation> _qualifiers;
        private Type _injectionPointType;

        public Builder(Type injectionPointType) {
            this._injectionPointType = injectionPointType;
        }

        public ComponentPropertiesModel build() {
            Objects.requireNonNull(this._delcaringClass);
            Objects.requireNonNull(this._injectionPointType);
            return new ComponentPropertiesModel(this._injectionPointType, this._delcaringClass, this._pid, this._qualifiers);
        }

        public Builder declaringClass(Class<?> delcaringClass) {
            this._delcaringClass = delcaringClass;
            return this;
        }

        public Builder qualifiers(Set<Annotation> qualifiers) {
            this._qualifiers = qualifiers;
            this._pid = this._qualifiers.stream().filter(PID.class::isInstance).map(PID.class::cast).findFirst().orElse(null);
            return this;
        }
    }
}

