/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Priority;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.container.internal.Activator;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.spi.configuration.Configuration;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.ConfigurationDTO;

public class ConfigurationExtension
extends AbstractMap<String, Object>
implements Configuration,
Extension {
    private static final String CONTEXT_PATH_PREFIX = "(osgi.http.whiteboard.context.path=";
    private static final String DEFAULT_APPLICATION_FILTER = "(osgi.jaxrs.name=.default)";
    private static final String DEFAULT_CONTEXT_FILTER = "(osgi.http.whiteboard.context.name=default)";
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final ContainerState _containerState;
    private final Map<String, Object> _configuration;

    protected ConfigurationExtension() {
        this._containerState = null;
        this._configuration = null;
    }

    public ConfigurationExtension(ContainerState containerState) {
        this._containerState = containerState;
        TreeMap<String, Object> configuration = new TreeMap<String, Object>();
        if (!(this._containerState.containerDTO().components == null || this._containerState.containerDTO().components.isEmpty() || ((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances == null || ((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances.isEmpty() || ((ComponentInstanceDTO)((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances.get((int)0)).configurations == null || ((ComponentInstanceDTO)((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances.get((int)0)).configurations.isEmpty())) {
            configuration = new TreeMap(((ConfigurationDTO)((ComponentInstanceDTO)((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances.get((int)0)).configurations.get((int)0)).properties);
        }
        configuration.put("osgi.http.whiteboard.context.select", this.getSelectedContext(configuration));
        configuration.put("osgi.jaxrs.application.select", this.getSelectedApplication(configuration));
        this._configuration = Collections.unmodifiableMap(configuration);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._configuration.entrySet();
    }

    void init(@Priority(value=0) @Observes BeforeBeanDiscovery bbd, BeanManager beanManager) {
        Activator.put(this._containerState.bundle(), beanManager);
        Event event = beanManager.getEvent();
        event.fire((Object)this);
    }

    void destroy(@Priority(value=2147482647) @Observes BeforeShutdown bs) {
        Activator.remove(this._containerState.bundle());
    }

    String getSelectedApplication(Map<String, Object> configuration) {
        if (configuration.containsKey("osgi.jaxrs.application.select")) {
            return String.valueOf(this._configuration.get("osgi.jaxrs.application.select"));
        }
        Map<String, Object> attributes = this._containerState.cdiAttributes();
        if (attributes.containsKey("osgi.jaxrs.application.select")) {
            return String.valueOf(attributes.get("osgi.jaxrs.application.select"));
        }
        return DEFAULT_APPLICATION_FILTER;
    }

    String getSelectedContext(Map<String, Object> configuration) {
        if (configuration.containsKey("osgi.http.whiteboard.context.select")) {
            return String.valueOf(this._configuration.get("osgi.http.whiteboard.context.select"));
        }
        Map<String, Object> attributes = this._containerState.cdiAttributes();
        if (attributes.containsKey("osgi.http.whiteboard.context.select")) {
            return String.valueOf(attributes.get("osgi.http.whiteboard.context.select"));
        }
        Dictionary headers = this._containerState.bundle().getHeaders();
        if (headers != null && headers.get(WEB_CONTEXT_PATH) != null) {
            return CONTEXT_PATH_PREFIX + (String)headers.get(WEB_CONTEXT_PATH) + ")";
        }
        return DEFAULT_CONTEXT_FILTER;
    }
}

