/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.annotated;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.aries.cdi.container.internal.annotated.AnnotatedConstructorImpl;
import org.apache.aries.cdi.container.internal.annotated.AnnotatedFieldImpl;
import org.apache.aries.cdi.container.internal.annotated.AnnotatedImpl;
import org.apache.aries.cdi.container.internal.annotated.AnnotatedMethodImpl;
import org.apache.aries.cdi.container.internal.util.Reflection;

public class AnnotatedTypeImpl<X>
extends AnnotatedImpl<X>
implements AnnotatedType<X> {
    private final Class<X> _declaringClass;
    private final Set<AnnotatedConstructor<X>> _constructors;
    private final Set<AnnotatedField<? super X>> _fields;
    private final Set<AnnotatedMethod<? super X>> _methods;

    public AnnotatedTypeImpl(Class<X> declaringClass) {
        super(declaringClass, declaringClass);
        this._declaringClass = declaringClass;
        this._constructors = Reflection.allConstructors(this._declaringClass).map(c -> new AnnotatedConstructorImpl(this, c)).collect(Collectors.toSet());
        this._fields = Reflection.allFields(this._declaringClass).map(f -> new AnnotatedFieldImpl(this, (Field)f)).collect(Collectors.toSet());
        this._methods = Reflection.allMethods(this._declaringClass).map(m -> new AnnotatedMethodImpl(this, (Method)m)).collect(Collectors.toSet());
    }

    public Class<X> getJavaClass() {
        return this._declaringClass;
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this._constructors;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this._methods;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this._fields;
    }
}

