/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.model.Component;
import org.apache.aries.cdi.container.internal.model.ContainerActivator;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentInstanceDTO;
import org.apache.aries.cdi.container.internal.model.InstanceActivator;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.log.Logger;
import org.osgi.util.promise.Promise;

public class ContainerComponent
extends Component {
    private final InstanceActivator.Builder<?> _activatorBuilder;
    private final Logger _log;
    private volatile ComponentDTO _snapshot;
    private final ComponentTemplateDTO _template;

    protected ContainerComponent(Builder builder) {
        super(builder);
        this._log = this.containerState.containerLogs().getLogger(this.getClass());
        this._template = builder._templateDTO;
        this._activatorBuilder = builder._activatorBuilder;
    }

    @Override
    public boolean close() {
        try (Syncro open = this.syncro.open();){
            if (this._snapshot == null) {
                boolean bl = true;
                return bl;
            }
            this._snapshot.instances.removeIf(instance -> {
                ExtendedComponentInstanceDTO einstance = (ExtendedComponentInstanceDTO)((Object)instance);
                Promise result = this.submit(einstance.closeOp(), einstance::close).onFailure(f -> this._log.error(l -> l.error("CCR Error in container component close for {} on {}", new Object[]{einstance.ident(), this.bundle(), f})));
                try {
                    return (Boolean)result.getValue();
                }
                catch (InterruptedException | InvocationTargetException e) {
                    return (Boolean)Throw.exception(e);
                }
            });
            this.containerState.containerDTO().components.remove(this._snapshot);
            this._snapshot = null;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.CONTAINER_COMPONENT, this._template.name);
    }

    @Override
    public List<ConfigurationTemplateDTO> configurationTemplates() {
        return this._template.configurations;
    }

    @Override
    public List<ComponentInstanceDTO> instances() {
        if (this._snapshot == null) {
            return Collections.emptyList();
        }
        return this._snapshot.instances;
    }

    @Override
    public boolean open() {
        try (Syncro open = this.syncro.open();){
            this._snapshot = new ComponentDTO();
            this._snapshot.instances = new CopyOnWriteArrayList();
            this._snapshot.template = this._template;
            this.containerState.containerDTO().components.add(this._snapshot);
            ExtendedComponentInstanceDTO instanceDTO = new ExtendedComponentInstanceDTO(this.containerState, this._activatorBuilder);
            instanceDTO.activations = new CopyOnWriteArrayList();
            instanceDTO.configurations = new CopyOnWriteArrayList();
            instanceDTO.references = new CopyOnWriteArrayList();
            instanceDTO.template = this._template;
            this._snapshot.instances.add(instanceDTO);
            this.submit(instanceDTO.openOp(), instanceDTO::open).onFailure(f -> this._log.error(l -> l.error("CCR Error in container component open for {} on {}", (Object)this._template.name, (Object)this.containerState.bundle())));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.CONTAINER_COMPONENT, this._template.name);
    }

    @Override
    public ComponentDTO snapshot() {
        return this._snapshot;
    }

    @Override
    public ComponentTemplateDTO template() {
        return this._template;
    }

    public static class Builder
    extends Component.Builder<Builder> {
        public Builder(ContainerState containerState, ContainerActivator.Builder activatorBuilder) {
            super(containerState, activatorBuilder);
        }

        @Override
        public ContainerComponent build() {
            this.template(this._containerState.containerComponentTemplateDTO());
            return new ContainerComponent(this);
        }
    }
}

