/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.Binder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.reference.BindServiceReference;
import org.osgi.service.log.Logger;

public class BindServiceReferenceImpl<T>
implements Binder<T>,
BindServiceReference<T> {
    private final ContainerState _containerState;
    private final Logger _log;
    private final List<ServiceReference<T>> _queue = new CopyOnWriteArrayList<ServiceReference<T>>();
    private final AtomicBoolean _enqueue = new AtomicBoolean(true);
    private volatile Optional<Consumer<ServiceReference<T>>> onAdding = Optional.empty();
    private volatile Optional<BiConsumer<ServiceReference<T>, T>> onAddingBi = Optional.empty();
    private volatile Optional<Consumer<ServiceReference<T>>> onUpdate = Optional.empty();
    private volatile Optional<BiConsumer<ServiceReference<T>, T>> onUpdateBi = Optional.empty();
    private volatile Optional<Consumer<ServiceReference<T>>> onRemove = Optional.empty();
    private volatile Optional<BiConsumer<ServiceReference<T>, T>> onRemoveBi = Optional.empty();
    private volatile T service;

    public BindServiceReferenceImpl(ContainerState containerState) {
        this._containerState = containerState;
        this._log = this._containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public BindServiceReferenceImpl<T> addingService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.add(reference);
            return this;
        }
        BundleContext bundleContext = this._containerState.bundleContext();
        this.service = bundleContext.getService(reference);
        this.onAdding.ifPresent(c -> {
            try {
                c.accept(reference);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onAddingBi.ifPresent(c -> {
            try {
                c.accept(reference, this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindServiceReferenceImpl<T> modifiedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            return this;
        }
        this.onUpdate.ifPresent(c -> {
            try {
                c.accept(reference);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onUpdateBi.ifPresent(c -> {
            try {
                c.accept(reference, this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindServiceReferenceImpl<T> removedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.remove(reference);
            return this;
        }
        this.onRemove.ifPresent(c -> {
            try {
                c.accept(reference);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onRemoveBi.ifPresent(c -> {
            try {
                c.accept(reference, this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    public void bind() {
        this._enqueue.set(false);
        this._queue.removeIf(reference -> {
            this.addingService((ServiceReference)reference);
            return true;
        });
    }

    public BindServiceReferenceImpl<T> adding(Consumer<ServiceReference<T>> action) {
        this.onAdding = Optional.ofNullable(action);
        return this;
    }

    public BindServiceReferenceImpl<T> adding(BiConsumer<ServiceReference<T>, T> action) {
        this.onAddingBi = Optional.ofNullable(action);
        return this;
    }

    public BindServiceReferenceImpl<T> modified(Consumer<ServiceReference<T>> consumer) {
        this.onUpdate = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceReferenceImpl<T> modified(BiConsumer<ServiceReference<T>, T> consumer) {
        this.onUpdateBi = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceReferenceImpl<T> removed(Consumer<ServiceReference<T>> consumer) {
        this.onRemove = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceReferenceImpl<T> removed(BiConsumer<ServiceReference<T>, T> consumer) {
        this.onRemoveBi = Optional.ofNullable(consumer);
        return this;
    }
}

