/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Vetoed;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.BeansModel;
import org.apache.aries.cdi.container.internal.model.OSGiBean;
import org.apache.aries.cdi.container.internal.util.Reflection;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.log.Logger;

public class BeansModelBuilder {
    private final ClassLoader _aggregateClassLoader;
    private final Map<String, Object> _attributes;
    private final Bundle _bundle;
    private final BundleWiring _bundleWiring;
    private final ContainerState _containerState;
    private final Logger _log;

    public BeansModelBuilder(ContainerState containerState, ClassLoader aggregateClassLoader, BundleWiring bundleWiring, Map<String, Object> cdiAttributes) {
        this._containerState = containerState;
        this._aggregateClassLoader = aggregateClassLoader;
        this._bundleWiring = bundleWiring;
        this._attributes = cdiAttributes;
        this._bundle = this._bundleWiring.getBundle();
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    public BeansModel build() {
        ArrayList<URL> beanDescriptorURLs = new ArrayList<URL>();
        Map<String, Object> attributes = this.getAttributes();
        ArrayList<String> beanDescriptorPaths = (ArrayList<String>)Reflection.cast(attributes.get("descriptor"));
        if (beanDescriptorPaths == null) {
            beanDescriptorPaths = new ArrayList<String>();
        }
        if (beanDescriptorPaths.isEmpty()) {
            beanDescriptorPaths.add("META-INF/beans.xml");
        }
        if (beanDescriptorPaths != null) {
            for (String descriptorPath : beanDescriptorPaths) {
                URL url = this.getResource(descriptorPath);
                if (url == null) continue;
                beanDescriptorURLs.add(url);
            }
        }
        List beanClassNames = Optional.ofNullable(this._attributes.get("beans")).map(v -> (List)v).orElse(Collections.emptyList());
        HashMap<String, OSGiBean> beans = new HashMap<String, OSGiBean>();
        for (String beanClassName : beanClassNames) {
            try {
                Class<?> clazz = this._aggregateClassLoader.loadClass(beanClassName);
                if (clazz.isAnnotationPresent(Vetoed.class) || clazz.getPackage() != null && clazz.getPackage().isAnnotationPresent(Vetoed.class)) continue;
                beans.put(beanClassName, new OSGiBean.Builder(this._containerState.containerLogs(), clazz).build());
                this._log.debug(l -> l.debug("CCR found bean {} on {}", (Object)beanClassName, (Object)this._containerState.bundle()));
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR Error loading class {} on {}", new Object[]{beanClassName, this._containerState.bundle(), t}));
                this._containerState.error(t);
            }
        }
        return new BeansModel(beans, beanDescriptorURLs);
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public URL getResource(String resource) {
        return this._bundle.getResource(resource);
    }
}

