/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.aries.cdi.extension.spi.adapt.FiltersOn;
import org.apache.aries.cdi.extension.spi.adapt.MergeServiceTypes;
import org.apache.aries.cdi.extension.spi.adapt.ProcessPotentialService;
import org.apache.aries.cdi.extension.spi.adapt.RegisterExtension;
import org.apache.aries.cdi.extension.spi.annotation.AdaptedService;
import org.osgi.service.cdi.annotations.Service;

public class ServiceAdapterExtension
implements Extension {
    private static final Predicate<AnnotatedType<?>> ANNOTATED_TYPE_TRUE_PREDICATE = at -> true;
    private boolean started;
    private Collection<Map.Entry<Predicate<AnnotatedType<?>>, BiConsumer<BeanManager, ProcessAnnotatedType<?>>>> forwardingObservers = new ArrayList();

    void capturePotentialServiceObservers(@Observes RegisterExtension registerExtension) {
        if (this.started) {
            throw new IllegalStateException("Container already started");
        }
        this.forwardingObservers.addAll(this.forMethods(registerExtension.getExtension().getClass()).map(method -> new AbstractMap.SimpleImmutableEntry<Extension, Method>(registerExtension.getExtension(), (Method)method)).filter(method -> Stream.of(((Method)method.getValue()).getParameters()).anyMatch(p -> p.isAnnotationPresent(Observes.class) && p.getType() == ProcessPotentialService.class)).map(e -> new AbstractMap.SimpleImmutableEntry(this.toPredicate((Method)e.getValue()), this.toConsumer((Method)e.getValue(), (Extension)e.getKey()))).collect(Collectors.toList()));
        this.forwardingObservers.addAll(registerExtension.getBuilders().stream().map(builder -> new AbstractMap.SimpleImmutableEntry(this.toPredicate(builder.getAnnotations(), builder.getTypes()), (bm, pat) -> builder.getConsumer().accept(bm, new ProcessPotentialService(pat)))).collect(Collectors.toList()));
    }

    <T> void forwardToObservers(@Observes ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        AnnotatedType annotatedType;
        if (!this.forwardingObservers.isEmpty() && !(annotatedType = pat.getAnnotatedType()).isAnnotationPresent(Service.class)) {
            this.forwardingObservers.stream().filter(predicateWithObserver -> ((Predicate)predicateWithObserver.getKey()).test(annotatedType)).map(Map.Entry::getValue).forEach(observer -> observer.accept(beanManager, pat));
        }
    }

    void mergeAdaptedServiceTypes(@Observes MergeServiceTypes mergeServiceTypes) {
        Class[] services;
        if (this.started) {
            throw new IllegalStateException("Container already started");
        }
        AdaptedService adaptedService = (AdaptedService)mergeServiceTypes.getProcessAnnotatedType().getAnnotatedType().getAnnotation(AdaptedService.class);
        AnnotatedTypeConfigurator configurator = mergeServiceTypes.getProcessAnnotatedType().configureAnnotatedType();
        if (adaptedService != null) {
            configurator.remove(a -> a.annotationType() == AdaptedService.class);
            services = (Class[])Stream.concat(Stream.of(mergeServiceTypes.getTypes()), Stream.of(adaptedService.value())).distinct().toArray(Class[]::new);
        } else {
            services = mergeServiceTypes.getTypes();
        }
        configurator.add((Annotation)AdaptedService.Literal.of((Class[])services));
    }

    void setStarted(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.started = true;
    }

    private Predicate<AnnotatedType<?>> toPredicate(Method method) {
        return Stream.of(method.getParameters()).filter(parameter -> parameter.isAnnotationPresent(Observes.class)).findFirst().map(parameter -> parameter.getAnnotation(FiltersOn.class)).map(filters -> this.toPredicate(Arrays.asList(filters.annotations()), Arrays.asList(filters.types()))).orElse(ANNOTATED_TYPE_TRUE_PREDICATE);
    }

    private Predicate<AnnotatedType<?>> toPredicate(Collection<Class<?>> annotations, Collection<Class<?>> types) {
        return this.filterWithAnnotations(annotations).and(this.filterWithTypes(types));
    }

    private BiConsumer<BeanManager, ProcessAnnotatedType<?>> toConsumer(Method method, Extension instance) {
        BiFunction[] argsFactory = (BiFunction[])Stream.of(method.getParameters()).map(parameter -> this.lookupMethod(method, (Parameter)parameter)).toArray(BiFunction[]::new);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return (bm, pat) -> {
            try {
                method.invoke((Object)instance, (Object[])Stream.of(argsFactory).map(fn -> fn.apply(bm, pat)).toArray(Object[]::new));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        };
    }

    private BiFunction<BeanManager, ProcessAnnotatedType<?>, Object> lookupMethod(Method method, Parameter parameter) {
        if (BeanManager.class == parameter.getType()) {
            return (bm, pat) -> bm;
        }
        if (ProcessPotentialService.class == parameter.getType()) {
            return (bm, pat) -> new ProcessPotentialService(pat);
        }
        throw new IllegalArgumentException("Unsupported type: " + parameter.getType() + " on " + method);
    }

    private Predicate<AnnotatedType<?>> filterWithTypes(Collection<Class<?>> filterOnTypes) {
        return Optional.of(filterOnTypes).filter(this::shouldNotIgnore).map(types -> annotatedType -> types.stream().anyMatch(t -> annotatedType.getJavaClass().isAssignableFrom((Class<?>)t))).orElse(ANNOTATED_TYPE_TRUE_PREDICATE);
    }

    private Predicate<AnnotatedType<?>> filterWithAnnotations(Collection<Class<?>> filterOnAnnotations) {
        return Optional.of(filterOnAnnotations).filter(this::shouldNotIgnore).map(withAnnotations -> annotatedType -> Stream.of(Stream.of(annotatedType.getAnnotations()), annotatedType.getFields().stream().map(Annotated::getAnnotations), Stream.concat(annotatedType.getMethods().stream(), annotatedType.getConstructors().stream()).flatMap(m -> Stream.concat(Stream.of(m.getAnnotations()), m.getParameters().stream().map(Annotated::getAnnotations)))).flatMap(Function.identity()).anyMatch(annotations -> annotations.stream().anyMatch(annotation -> withAnnotations.stream().anyMatch(withAnnotation -> Stream.concat(Stream.of(annotation.annotationType()), Stream.of(annotation.annotationType().getAnnotations()).map(Annotation::annotationType)).anyMatch(withAnnotation::isAssignableFrom))))).orElse(ANNOTATED_TYPE_TRUE_PREDICATE);
    }

    private boolean shouldNotIgnore(Collection<Class<?>> annotations) {
        return annotations.size() != 1 || FiltersOn.class != annotations.iterator().next();
    }

    private Stream<Method> forMethods(Class<?> clazz) {
        return clazz == Object.class || clazz == null ? Stream.empty() : Stream.concat(Stream.of(clazz.getDeclaredMethods()), this.forMethods(clazz.getSuperclass()));
    }
}

