/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.aries.cdi.container.internal.container.Mark;
import org.apache.aries.cdi.container.internal.model.CollectionType;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.aries.cdi.container.internal.util.Sets;
import org.osgi.service.cdi.ComponentType;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.ReferencePolicy;
import org.osgi.service.cdi.ReferencePolicyOption;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.Reference;
import org.osgi.service.cdi.annotations.Reluctant;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.log.Logger;

public class ReferenceBean
implements Bean<Object> {
    private volatile BeanManager _bm;
    private final ComponentTemplateDTO _component;
    private final Logger _log;
    private final Set<Annotation> _qualifiers;
    private volatile ExtendedReferenceDTO _snapshot;
    private volatile String _string;
    private final ExtendedReferenceTemplateDTO _template;
    private final Set<Type> _types;

    public ReferenceBean(Logs logs, ComponentTemplateDTO component, ExtendedReferenceTemplateDTO template) {
        this._component = component;
        this._template = template;
        this._log = logs.getLogger(this.getClass());
        this._qualifiers = Sets.hashSet(Reference.Literal.of(Object.class, (String)""), Default.Literal.INSTANCE);
        if (this._template.policyOption == ReferencePolicyOption.RELUCTANT) {
            this._qualifiers.add((Annotation)Reluctant.Literal.INSTANCE);
        }
        this._types = Sets.hashSet(this._template.injectionPointType, Object.class);
    }

    public Object create(final CreationalContext<Object> c) {
        Objects.requireNonNull(this._bm);
        Objects.requireNonNull(this._snapshot);
        this._log.debug(l -> l.debug("Creating {}", (Object)this));
        final SortedMap tracked = this._snapshot.serviceTracker.getTracked();
        if (this._template.collectionType == CollectionType.BINDER_SERVICE || this._template.collectionType == CollectionType.BINDER_REFERENCE || this._template.collectionType == CollectionType.BINDER_BEAN_SERVICE_OBJECTS) {
            return this._snapshot.binder;
        }
        if (this._template.policy == ReferencePolicy.DYNAMIC) {
            if (this._template.maximumCardinality == MaximumCardinality.MANY) {
                return new Provider<List<Object>>(){

                    public List<Object> get() {
                        return tracked.values().stream().map(s -> ReferenceBean.this.decorate(c, s)).collect(Collectors.toList());
                    }
                };
            }
            if (this._template.minimumCardinality == 0) {
                return new Provider<Optional<Object>>(){

                    public Optional<Object> get() {
                        Iterator iterator = tracked.values().iterator();
                        if (iterator.hasNext()) {
                            return Optional.of(ReferenceBean.this.decorate(c, iterator.next()));
                        }
                        return Optional.empty();
                    }
                };
            }
            return new Provider<Object>(){

                public Object get() {
                    Iterator iterator = tracked.values().iterator();
                    if (iterator.hasNext()) {
                        return ReferenceBean.this.decorate(c, iterator.next());
                    }
                    return null;
                }
            };
        }
        if (this._template.maximumCardinality == MaximumCardinality.MANY) {
            return tracked.values().stream().map(s -> this.decorate(c, s)).collect(Collectors.toList());
        }
        if (this._template.minimumCardinality == 0) {
            Iterator iterator = tracked.values().iterator();
            if (iterator.hasNext()) {
                return Optional.of(this.decorate(c, iterator.next()));
            }
            return Optional.empty();
        }
        Iterator iterator = tracked.values().iterator();
        if (iterator.hasNext()) {
            return this.decorate(c, iterator.next());
        }
        return null;
    }

    private <S> S decorate(CreationalContext<S> c, S s) {
        return s;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Class<?> getBeanClass() {
        return this._template.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        if (this._component.type == ComponentType.CONTAINER) {
            return Dependent.class;
        }
        return ComponentScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this._types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public void setMark(Mark mark) {
        this._qualifiers.add(mark);
        this._string = null;
    }

    public void setReferenceDTO(ExtendedReferenceDTO snapshot) {
        this._snapshot = snapshot;
    }

    public void setBeanManager(BeanManager bm) {
        this._bm = bm;
    }

    public String toString() {
        if (this._string == null) {
            this._string = "ReferenceBean[" + this._template.name + ", " + this._template.injectionPointType + ", " + this.getScope().getSimpleName() + ", " + this._qualifiers + "]";
        }
        return this._string;
    }
}

