/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.utils;

import com.liferay.gs.testFramework.utils.SeleniumWaitMethods;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SeleniumCommonMethods {
    private WebDriver _webDriver;

    public SeleniumCommonMethods(WebDriver webDriver) {
        this._webDriver = webDriver;
    }

    public void acceptBrowserDialog() {
        Alert alert = this._webDriver.switchTo().alert();
        alert.accept();
    }

    public void waitElementBeVisible(By locator) {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public void waitElementBePresent(By locator) {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public void waitElementBeClickable(By locator) {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public void clickOnElement(By locator) {
        this.waitElementBePresent(locator);
        this.waitElementBeVisible(locator);
        this.waitElementBeClickable(locator);
        this._webDriver.findElement(locator).click();
    }

    public void clearAndWriteOnElement(By locator, CharSequence ... keysToSend) {
        this.waitElementBePresent(locator);
        this.waitElementBeVisible(locator);
        this._webDriver.findElement(locator).clear();
        this._webDriver.findElement(locator).sendKeys(keysToSend);
    }

    public void writeOnElement(By locator, CharSequence ... keysToSend) {
        this.waitElementBePresent(locator);
        this.waitElementBeVisible(locator);
        this._webDriver.findElement(locator).sendKeys(keysToSend);
    }
}

