/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.driver;

import com.liferay.gs.testFramework.core.SeleniumReadPropertyKeys;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public final class WebDriverBuilder {
    private static String _chromeDriver_Path = SeleniumReadPropertyKeys.getChromeDriverPath();
    private static String _configurationErrorMessage = null;
    private static String _downloadSaveFilePath = SeleniumReadPropertyKeys.getDownloadSaveFilePath();
    private static String _geckoDriver_Path = SeleniumReadPropertyKeys.getGeckoDriverPath();

    protected static WebDriver build() {
        if (WebDriverBuilder._defaultPropertiesFilePathWasConfigured()) {
            WebDriver webDriver = WebDriverBuilder._build();
            WebDriverBuilder._configure(webDriver);
            return webDriver;
        }
        System.out.println(_configurationErrorMessage);
        return null;
    }

    private static WebDriver _build() {
        switch (SeleniumReadPropertyKeys.getDefaultPlatformName()) {
            case "defaultFF": {
                return WebDriverBuilder._configureDefaultFF();
            }
            case "defaultGC": {
                return WebDriverBuilder._configureDefaultGC();
            }
            case "defaultGCHeadless": {
                return WebDriverBuilder._configureDefaultGCHeadless();
            }
        }
        return null;
    }

    private static boolean _chromeDriverWasConfigured() {
        File chromeDriverFile = new File(_chromeDriver_Path);
        if (chromeDriverFile.exists() && chromeDriverFile.canExecute()) {
            _configurationErrorMessage = "The chromedriver was configured correctly";
            return true;
        }
        _configurationErrorMessage = "The chromedriver should be configured in '" + _chromeDriver_Path + "' according the project wiki.";
        return false;
    }

    private static void _configure(WebDriver webDriver) {
        WebDriver.Options manage = webDriver.manage();
        manage.window().setSize(new Dimension(1024, 945));
        manage.timeouts().implicitlyWait((long)SeleniumReadPropertyKeys.getTimeOut(), TimeUnit.SECONDS);
    }

    private static FirefoxDriver _configureDefaultFF() {
        if (WebDriverBuilder._geckoDriverWasConfigured()) {
            System.setProperty("webdriver.gecko.driver", _geckoDriver_Path);
            return new FirefoxDriver();
        }
        System.out.println(_configurationErrorMessage);
        return null;
    }

    private static ChromeDriver _configureDefaultGC() {
        if (WebDriverBuilder._chromeDriverWasConfigured()) {
            System.setProperty("webdriver.chrome.driver", _chromeDriver_Path);
            if (Objects.equals(_downloadSaveFilePath, "default")) {
                return new ChromeDriver();
            }
            HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
            chromePrefs.put("download.default_directory", _downloadSaveFilePath);
            chromePrefs.put("profile.default_content_settings.popups", 0);
            ChromeOptions options = new ChromeOptions();
            options.setExperimentalOption("prefs", chromePrefs);
            DesiredCapabilities cap = DesiredCapabilities.chrome();
            cap.setCapability("acceptSslCerts", true);
            cap.setCapability("goog:chromeOptions", (Object)options);
            return new ChromeDriver((Capabilities)cap);
        }
        System.out.println(_configurationErrorMessage);
        return null;
    }

    private static ChromeDriver _configureDefaultGCHeadless() {
        if (WebDriverBuilder._chromeDriverWasConfigured()) {
            ChromeOptions chromeOptions = new ChromeOptions();
            System.setProperty("webdriver.chrome.driver", _chromeDriver_Path);
            chromeOptions.addArguments(new String[]{"--headless"});
            return new ChromeDriver(chromeOptions);
        }
        System.out.println(_configurationErrorMessage);
        return null;
    }

    private static boolean _defaultPropertiesFilePathWasConfigured() {
        File defaultPropertiesFile = new File(SeleniumReadPropertyKeys.getSeleniumPropertyKeysFilePath());
        if (defaultPropertiesFile.exists() && defaultPropertiesFile.canRead()) {
            _configurationErrorMessage = "The defaultProperties.properties file was configured correctly";
            return true;
        }
        _configurationErrorMessage = "The defaultProperties.properties should be configured in '" + SeleniumReadPropertyKeys.getSeleniumPropertyKeysFilePath() + "' according the project wiki.";
        return false;
    }

    private static boolean _geckoDriverWasConfigured() {
        File genckoDriverFile = new File(_geckoDriver_Path);
        if (genckoDriverFile.exists() && genckoDriverFile.canExecute()) {
            _configurationErrorMessage = "The geckodriver was configured correctly";
            return true;
        }
        _configurationErrorMessage = "The geckodriver should be configured in '" + _geckoDriver_Path + "' according the project wiki.";
        return false;
    }
}

