/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser.internal;

import com.liferay.faces.test.selenium.browser.BrowserDriver;
import com.liferay.faces.test.selenium.browser.WaitingAsserter;
import com.liferay.faces.test.selenium.browser.internal.ExpectedConditionsUtil;
import com.liferay.faces.test.selenium.expectedconditions.ElementEnabled;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class WaitingAsserterImpl
implements WaitingAsserter {
    private BrowserDriver browserDriver;

    public WaitingAsserterImpl(BrowserDriver browserDriver) {
        this.browserDriver = browserDriver;
    }

    private static AssertionError createAssertionErrorWithoutExtraInfo(final TimeoutException timeoutException) {
        return new AssertionError((Object)timeoutException){

            public String getMessage() {
                String systemInformation;
                BuildInfo buildInformation;
                String message = super.getMessage();
                String additionalInformation = timeoutException.getAdditionalInformation();
                if (additionalInformation != null) {
                    message = message.replace(additionalInformation, "");
                }
                if ((buildInformation = timeoutException.getBuildInformation()) != null) {
                    message = message.replace(buildInformation.toString(), "");
                }
                if ((systemInformation = timeoutException.getSystemInformation()) != null) {
                    message = message.replace(systemInformation, "");
                }
                message = message.replaceFirst("\n+$", "").replaceAll("\n+", "\n");
                return message;
            }
        };
    }

    @Override
    public void assertElementDisplayed(String elementXpath) {
        this.assertTrue(ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)elementXpath)));
    }

    @Override
    public void assertElementEnabled(String elementXpath) {
        this.assertElementEnabled(elementXpath, true);
    }

    @Override
    public void assertElementEnabled(String elementXpath, boolean elementMustBeDisplayed) {
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(new ElementEnabled(elementXpath), elementMustBeDisplayed, byXpath);
        this.assertTrue(expectedCondition);
    }

    @Override
    public void assertElementNotDisplayed(String elementXpath) {
        this.assertTrue(ExpectedConditions.invisibilityOfElementLocated((By)By.xpath((String)elementXpath)));
    }

    @Override
    public void assertElementNotPresent(String elementXpath) {
        this.assertFalse(ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)elementXpath)));
    }

    @Override
    public void assertElementPresent(String elementXpath) {
        this.assertTrue(ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)elementXpath)));
    }

    @Override
    public void assertFalse(ExpectedCondition expectedCondition) {
        try {
            this.browserDriver.waitFor(ExpectedConditions.not((ExpectedCondition)expectedCondition));
        }
        catch (TimeoutException e) {
            throw WaitingAsserterImpl.createAssertionErrorWithoutExtraInfo(e);
        }
    }

    @Override
    public void assertTextNotPresentInElement(String text, String elementXpath) {
        this.assertTextNotPresentInElement(text, elementXpath, true);
    }

    @Override
    public void assertTextNotPresentInElement(String text, String elementXpath, boolean elementMustBeDisplayed) {
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditions.not((ExpectedCondition)ExpectedConditions.textToBePresentInElementLocated((By)byXpath, (String)text));
        expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(expectedCondition, elementMustBeDisplayed, byXpath);
        this.assertTrue(expectedCondition);
    }

    @Override
    public void assertTextPresentInElement(String text, String elementXpath) {
        this.assertTextPresentInElement(text, elementXpath, true);
    }

    @Override
    public void assertTextPresentInElement(String text, String elementXpath, boolean elementMustBeDisplayed) {
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditions.textToBePresentInElementLocated((By)byXpath, (String)text);
        expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(expectedCondition, elementMustBeDisplayed, byXpath);
        this.assertTrue(expectedCondition);
    }

    @Override
    public void assertTextPresentInElementValue(String text, String elementXpath) {
        this.assertTextPresentInElementValue(text, elementXpath, true);
    }

    @Override
    public void assertTextPresentInElementValue(String text, String elementXpath, boolean elementMustBeDisplayed) {
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditions.textToBePresentInElementValue((By)byXpath, (String)text);
        expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(expectedCondition, elementMustBeDisplayed, byXpath);
        this.assertTrue(expectedCondition);
    }

    @Override
    public void assertTrue(ExpectedCondition expectedCondition) {
        try {
            this.browserDriver.waitFor(expectedCondition);
        }
        catch (TimeoutException e) {
            throw WaitingAsserterImpl.createAssertionErrorWithoutExtraInfo(e);
        }
    }
}

