/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser;

import com.liferay.faces.test.selenium.browser.BrowserDriverManagingTesterBase;
import com.liferay.faces.test.selenium.browser.FileUploadTesterBase;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserDriverManagingTestSuiteListener
extends RunListener {
    public void testRunFinished(Result result) throws Exception {
        Files.walkFileTree(FileUploadTesterBase.OnDemandTemporaryFolder.INSTANCE.toPath(), new DeleteFileVisitor());
        BrowserDriverManagingTesterBase.doTearDown();
        super.testRunFinished(result);
    }

    private static final class DeleteFileVisitor
    extends SimpleFileVisitor<Path> {
        private static final Logger logger = LoggerFactory.getLogger(DeleteFileVisitor.class);

        private DeleteFileVisitor() {
        }

        private static FileVisitResult visitToDelete(Path path) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                logger.error("Failed to delete temporary test file: " + path.toString(), (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
            return DeleteFileVisitor.visitToDelete(directory);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            return DeleteFileVisitor.visitToDelete(file);
        }
    }
}

