/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser;

import com.liferay.faces.test.selenium.browser.BrowserDriver;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.openqa.selenium.WebDriver;

public abstract class BrowserDriverFactory {
    private static final BrowserDriverFactory browserDriverFactory;

    public static final BrowserDriver getBrowserDriver() {
        return browserDriverFactory.getBrowserDriverImplementation();
    }

    public static final BrowserDriver getBrowserDriver(String browserName, boolean browserHeadless, boolean browserSimulateMobile) {
        return browserDriverFactory.getBrowserDriverImplementation(browserName, browserHeadless, browserSimulateMobile);
    }

    public static final BrowserDriver getBrowserDriver(WebDriver webDriver, boolean browserHeadless, boolean browserSimulateMobile) {
        return browserDriverFactory.getBrowserDriverImplementation(webDriver, browserHeadless, browserSimulateMobile);
    }

    public abstract BrowserDriver getBrowserDriverImplementation();

    public abstract BrowserDriver getBrowserDriverImplementation(String var1, boolean var2, boolean var3);

    public abstract BrowserDriver getBrowserDriverImplementation(WebDriver var1, boolean var2, boolean var3);

    static {
        BrowserDriverFactory browserDriverFactoryImpl;
        ServiceLoader<BrowserDriverFactory> serviceLoader = ServiceLoader.load(BrowserDriverFactory.class);
        if (serviceLoader != null) {
            Iterator<BrowserDriverFactory> iterator = serviceLoader.iterator();
            browserDriverFactoryImpl = null;
            while (browserDriverFactoryImpl == null && iterator.hasNext()) {
                browserDriverFactoryImpl = iterator.next();
            }
            if (browserDriverFactoryImpl == null) {
                throw new NullPointerException("Unable locate service for " + BrowserDriverFactory.class.getName());
            }
        } else {
            throw new NullPointerException("Unable to acquire ServiceLoader for " + BrowserDriverFactory.class.getName());
        }
        browserDriverFactory = browserDriverFactoryImpl;
    }
}

