/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser;

import com.liferay.faces.test.selenium.browser.BrowserDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

public final class TestUtil {
    public static final String DEFAULT_BASE_URL;
    public static final String DEFAULT_PLUTO_CONTEXT = "/pluto/portal";
    public static final int DEFAULT_BROWSER_DRIVER_WAIT_TIME_OUT;

    private TestUtil() {
        throw new AssertionError();
    }

    public static int getBrowserDriverWaitTimeOut() {
        return TestUtil.getBrowserDriverWaitTimeOut(DEFAULT_BROWSER_DRIVER_WAIT_TIME_OUT);
    }

    public static int getBrowserDriverWaitTimeOut(Integer defaultTimeOutInSeconds) {
        String defaultTimeOutInSecondsString = defaultTimeOutInSeconds.toString();
        String timeOutInSecondsString = TestUtil.getSystemPropertyOrDefault("integration.browser.driver.wait.time.out", defaultTimeOutInSecondsString);
        return Integer.parseInt(timeOutInSecondsString);
    }

    public static String getContainer() {
        return TestUtil.getContainer("liferay");
    }

    public static String getContainer(String defaultContainer) {
        return TestUtil.getSystemPropertyOrDefault("integration.container", defaultContainer);
    }

    public static String getHost() {
        return TestUtil.getHost("localhost");
    }

    public static String getHost(String defaultHost) {
        return TestUtil.getSystemPropertyOrDefault("integration.host", defaultHost);
    }

    public static String getPort() {
        return TestUtil.getPort("8080");
    }

    public static String getPort(String defaultPort) {
        return TestUtil.getSystemPropertyOrDefault("integration.port", defaultPort);
    }

    public static String getProtocol() {
        return TestUtil.getProtocol("http");
    }

    public static String getProtocol(String defaultProtocol) {
        return TestUtil.getSystemPropertyOrDefault("integration.protocol", defaultProtocol);
    }

    public static String getSystemPropertyOrDefault(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName, "");
        if ("".equals(propertyValue)) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public static void signIn(BrowserDriver browserDriver) {
        String container = TestUtil.getContainer();
        TestUtil.signIn(browserDriver, container);
    }

    public static void signIn(BrowserDriver browserDriver, String container) {
        String defaultSignInContext = "";
        String defaultLoginXpath = "";
        String defaultPasswordXpath = "";
        String defaultSignInButtonXpath = "";
        String defaultLogin = "";
        String defaultPassword = "";
        if (container.contains("liferay")) {
            defaultSignInContext = "/c/portal/login";
            defaultLoginXpath = "//input[contains(@id, '_login') and @type='text']";
            defaultPasswordXpath = "//input[contains(@id, '_password') and @type='password']";
            defaultSignInButtonXpath = "//button[contains(., 'Sign In')]";
            defaultLogin = "test@liferay.com";
            defaultPassword = "test";
        } else if (container.contains("pluto")) {
            defaultSignInContext = DEFAULT_PLUTO_CONTEXT;
            defaultLoginXpath = "//input[contains(@id, '_username')]";
            defaultPasswordXpath = "//input[contains(@id, '_password')]";
            defaultSignInButtonXpath = "//input[contains(@id, '_login')]";
            defaultLogin = "pluto";
            defaultPassword = "pluto";
        }
        String signInContext = TestUtil.getSystemPropertyOrDefault("integration.sign.in.context", defaultSignInContext);
        String signInURL = DEFAULT_BASE_URL + signInContext;
        String loginXpath = TestUtil.getSystemPropertyOrDefault("integration.login.xpath", defaultLoginXpath);
        String passwordXpath = TestUtil.getSystemPropertyOrDefault("integration.password.xpath", defaultPasswordXpath);
        String signInButtonXpath = TestUtil.getSystemPropertyOrDefault("integration.sign.in.button.xpath", defaultSignInButtonXpath);
        String login = TestUtil.getSystemPropertyOrDefault("integration.login", defaultLogin);
        String password = TestUtil.getSystemPropertyOrDefault("integration.password", defaultPassword);
        TestUtil.signIn(browserDriver, signInURL, loginXpath, login, passwordXpath, password, signInButtonXpath);
    }

    public static void signIn(BrowserDriver browserDriver, String signInURL, String loginXpath, String login, String passwordXpath, String password, String signInButtonXpath) {
        browserDriver.navigateWindowTo(signInURL);
        browserDriver.waitForElementEnabled(loginXpath);
        browserDriver.clearElement(loginXpath);
        browserDriver.sendKeysToElement(loginXpath, login);
        browserDriver.clearElement(passwordXpath);
        browserDriver.sendKeysToElement(passwordXpath, password);
        WebElement loginElement = browserDriver.findElementByXpath(loginXpath);
        browserDriver.clickElement(signInButtonXpath);
        browserDriver.waitFor(ExpectedConditions.stalenessOf((WebElement)loginElement));
        browserDriver.waitForElementDisplayed("//body");
    }

    static {
        int defaultBrowserDriverWaitTimeOut = 5;
        if (TestUtil.getContainer().startsWith("pluto")) {
            defaultBrowserDriverWaitTimeOut = 3;
        }
        DEFAULT_BROWSER_DRIVER_WAIT_TIME_OUT = defaultBrowserDriverWaitTimeOut;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TestUtil.getProtocol());
        stringBuilder.append("://");
        stringBuilder.append(TestUtil.getHost());
        int port = Integer.parseInt(TestUtil.getPort());
        if (port > -1) {
            stringBuilder.append(":");
            stringBuilder.append(port);
        }
        DEFAULT_BASE_URL = stringBuilder.toString();
    }
}

