/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile;

import com.liferay.faces.bridge.component.inputfile.InputFileBase;
import com.liferay.faces.bridge.event.FileUploadEvent;
import java.io.Serializable;
import javax.el.MethodExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

@FacesComponent(value="com.liferay.faces.bridge.component.inputfile.InputFile")
public class InputFile
extends InputFileBase {
    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            MethodExpression methodExpression = this.getFileUploadListener();
            if (methodExpression != null && facesEvent instanceof FileUploadEvent) {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{facesEvent});
            }
        }
        catch (Exception e) {
            throw new AbortProcessingException((Throwable)e);
        }
    }

    public String getStyleClass() {
        String styleClass = (String)this.getStateHelper().eval((Serializable)HtmlInputText.PropertyKeys.styleClass, null);
        return this.concatCssClasses(styleClass, "bridge-input-file");
    }

    private String concatCssClasses(String ... classNames) {
        StringBuilder cssClassBuilder = new StringBuilder();
        boolean first = true;
        for (String className : classNames) {
            if (className == null) continue;
            if (!first) {
                cssClassBuilder.append(" ");
            }
            cssClassBuilder.append(className);
            first = false;
        }
        String allClasses = cssClassBuilder.toString();
        if (allClasses.length() == 0) {
            allClasses = null;
        }
        return allClasses;
    }
}

