/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.client.resource.v1_0;

import com.liferay.headless.commerce.machine.learning.client.dto.v1_0.SkuForecast;
import com.liferay.headless.commerce.machine.learning.client.http.HttpInvoker;
import com.liferay.headless.commerce.machine.learning.client.pagination.Page;
import com.liferay.headless.commerce.machine.learning.client.pagination.Pagination;
import com.liferay.headless.commerce.machine.learning.client.problem.Problem;
import com.liferay.headless.commerce.machine.learning.client.serdes.v1_0.SkuForecastSerDes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface SkuForecastResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<SkuForecast> getSkuForecastsByMonthlyRevenuePage(Integer var1, Date var2, Integer var3, String[] var4, Pagination var5) throws Exception;

    public HttpInvoker.HttpResponse getSkuForecastsByMonthlyRevenuePageHttpResponse(Integer var1, Date var2, Integer var3, String[] var4, Pagination var5) throws Exception;

    public static class SkuForecastResourceImpl
    implements SkuForecastResource {
        private static final Logger _logger = Logger.getLogger(SkuForecastResource.class.getName());
        private Builder _builder;

        @Override
        public Page<SkuForecast> getSkuForecastsByMonthlyRevenuePage(Integer forecastLength, Date forecastStartDate, Integer historyLength, String[] skus, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSkuForecastsByMonthlyRevenuePageHttpResponse(forecastLength, forecastStartDate, historyLength, skus, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, SkuForecastSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSkuForecastsByMonthlyRevenuePageHttpResponse(Integer forecastLength, Date forecastStartDate, Integer historyLength, String[] skus, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            if (forecastLength != null) {
                httpInvoker.parameter("forecastLength", String.valueOf(forecastLength));
            }
            if (forecastStartDate != null) {
                httpInvoker.parameter("forecastStartDate", liferayToJSONDateFormat.format(forecastStartDate));
            }
            if (historyLength != null) {
                httpInvoker.parameter("historyLength", String.valueOf(historyLength));
            }
            if (skus != null) {
                for (int i = 0; i < skus.length; ++i) {
                    httpInvoker.parameter("skus", String.valueOf(skus[i]));
                }
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-machine-learning/v1.0/skuForecasts/by-monthlyDemand");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private SkuForecastResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public SkuForecastResource build() {
            return new SkuForecastResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

