/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.client.serdes.v1_0;

import com.liferay.headless.commerce.machine.learning.client.dto.v1_0.Sku;
import com.liferay.headless.commerce.machine.learning.client.json.BaseJSONParser;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class SkuSerDes {
    public static Sku toDTO(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return (Sku)skuJSONParser.parseToDTO(json);
    }

    public static Sku[] toDTOs(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return (Sku[])skuJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Sku sku) {
        if (sku == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (sku.getCost() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"cost\": ");
            sb.append(sku.getCost());
        }
        if (sku.getDiscontinued() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discontinued\": ");
            sb.append(sku.getDiscontinued());
        }
        if (sku.getDisplayDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(sku.getDisplayDate()));
            sb.append("\"");
        }
        if (sku.getExpirationDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expirationDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(sku.getExpirationDate()));
            sb.append("\"");
        }
        if (sku.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (sku.getGtin() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"gtin\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getGtin()));
            sb.append("\"");
        }
        if (sku.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(sku.getId());
        }
        if (sku.getManufacturerPartNumber() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"manufacturerPartNumber\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getManufacturerPartNumber()));
            sb.append("\"");
        }
        if (sku.getPublished() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"published\": ");
            sb.append(sku.getPublished());
        }
        if (sku.getPurchasable() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"purchasable\": ");
            sb.append(sku.getPurchasable());
        }
        if (sku.getSku() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getSku()));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return skuJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Sku sku) {
        if (sku == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (sku.getCost() == null) {
            map.put("cost", null);
        } else {
            map.put("cost", String.valueOf(sku.getCost()));
        }
        if (sku.getDiscontinued() == null) {
            map.put("discontinued", null);
        } else {
            map.put("discontinued", String.valueOf(sku.getDiscontinued()));
        }
        if (sku.getDisplayDate() == null) {
            map.put("displayDate", null);
        } else {
            map.put("displayDate", liferayToJSONDateFormat.format(sku.getDisplayDate()));
        }
        if (sku.getExpirationDate() == null) {
            map.put("expirationDate", null);
        } else {
            map.put("expirationDate", liferayToJSONDateFormat.format(sku.getExpirationDate()));
        }
        if (sku.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(sku.getExternalReferenceCode()));
        }
        if (sku.getGtin() == null) {
            map.put("gtin", null);
        } else {
            map.put("gtin", String.valueOf(sku.getGtin()));
        }
        if (sku.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(sku.getId()));
        }
        if (sku.getManufacturerPartNumber() == null) {
            map.put("manufacturerPartNumber", null);
        } else {
            map.put("manufacturerPartNumber", String.valueOf(sku.getManufacturerPartNumber()));
        }
        if (sku.getPublished() == null) {
            map.put("published", null);
        } else {
            map.put("published", String.valueOf(sku.getPublished()));
        }
        if (sku.getPurchasable() == null) {
            map.put("purchasable", null);
        } else {
            map.put("purchasable", String.valueOf(sku.getPurchasable()));
        }
        if (sku.getSku() == null) {
            map.put("sku", null);
        } else {
            map.put("sku", String.valueOf(sku.getSku()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(SkuSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(SkuSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SkuSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class SkuJSONParser
    extends BaseJSONParser<Sku> {
        @Override
        protected Sku createDTO() {
            return new Sku();
        }

        protected Sku[] createDTOArray(int size) {
            return new Sku[size];
        }

        @Override
        protected void setField(Sku sku, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "cost")) {
                if (jsonParserFieldValue != null) {
                    sku.setCost(new BigDecimal((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "discontinued")) {
                if (jsonParserFieldValue != null) {
                    sku.setDiscontinued((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "displayDate")) {
                if (jsonParserFieldValue != null) {
                    sku.setDisplayDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "expirationDate")) {
                if (jsonParserFieldValue != null) {
                    sku.setExpirationDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    sku.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "gtin")) {
                if (jsonParserFieldValue != null) {
                    sku.setGtin((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    sku.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "manufacturerPartNumber")) {
                if (jsonParserFieldValue != null) {
                    sku.setManufacturerPartNumber((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "published")) {
                if (jsonParserFieldValue != null) {
                    sku.setPublished((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "purchasable")) {
                if (jsonParserFieldValue != null) {
                    sku.setPurchasable((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "sku") && jsonParserFieldValue != null) {
                sku.setSku((String)jsonParserFieldValue);
            }
        }
    }
}

