/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.exception.CPAttachmentFileEntryProtocolException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionOptionRelException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionOptionValueRelException;
import com.liferay.commerce.product.exception.NoSuchCPOptionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentBase64;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentUrl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;

public class AttachmentUtil {
    private static final String _TEMP_FILE_NAME = AttachmentUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AttachmentUtil.class);

    public static FileEntry addFileEntry(Attachment attachment, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((String)attachment.getAttachment())) {
            String base64EncodedContent = attachment.getAttachment();
            File file = FileUtil.createTempFile((byte[])Base64.decode((String)base64EncodedContent));
            return AttachmentUtil._addFileEntry(file, attachment.getContentType(), uniqueFileNameProvider, serviceContext);
        }
        if (Validator.isNotNull((String)attachment.getSrc())) {
            URL url = new URL(attachment.getSrc());
            if (Objects.equals(url.getProtocol(), "file")) {
                throw new CPAttachmentFileEntryProtocolException("Unsupported URL protocol");
            }
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            File file = FileUtil.createTempFile((InputStream)urlConnection.getInputStream());
            return AttachmentUtil._addFileEntry(file, attachment.getContentType(), uniqueFileNameProvider, serviceContext);
        }
        return null;
    }

    public static FileEntry addFileEntry(AttachmentBase64 attachmentBase64, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String base64EncodedContent = attachmentBase64.getAttachment();
        if (Validator.isNull((String)base64EncodedContent)) {
            return null;
        }
        File file = FileUtil.createTempFile((byte[])Base64.decode((String)base64EncodedContent));
        return AttachmentUtil._addFileEntry(file, attachmentBase64.getContentType(), uniqueFileNameProvider, serviceContext);
    }

    public static FileEntry addFileEntry(AttachmentUrl attachmentUrl, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (Validator.isNull((String)attachmentUrl.getSrc())) {
            return null;
        }
        File file = FileUtil.createTempFile((InputStream)HttpUtil.URLtoInputStream((String)attachmentUrl.getSrc()));
        return AttachmentUtil._addFileEntry(file, attachmentUrl.getContentType(), uniqueFileNameProvider, serviceContext);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(CPAttachmentFileEntryService cpAttachmentFileEntryService, CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, CPOptionService cpOptionService, UniqueFileNameProvider uniqueFileNameProvider, AttachmentBase64 attachmentBase64, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachmentBase64.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachmentBase64.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachmentBase64.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachmentBase64.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachmentBase64, uniqueFileNameProvider, serviceContext);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachmentBase64.getExternalReferenceCode(), serviceContext.getScopeGroupId(), classNameId, classPK, GetterUtil.getLong((Object)attachmentBase64.getId()), fileEntryId, false, null, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachmentBase64.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachmentBase64.getTitle()), AttachmentUtil._getJSON(cpDefinitionOptionRelService, cpDefinitionOptionValueRelService, cpOptionService, attachmentBase64.getOptions(), classPK, serviceContext.getCompanyId()), GetterUtil.getDouble((Object)attachmentBase64.getPriority()), type, serviceContext);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(CPAttachmentFileEntryService cpAttachmentFileEntryService, CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, CPOptionService cpOptionService, UniqueFileNameProvider uniqueFileNameProvider, AttachmentUrl attachmentUrl, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachmentUrl.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachmentUrl.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachmentUrl.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachmentUrl.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachmentUrl, uniqueFileNameProvider, serviceContext);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachmentUrl.getExternalReferenceCode(), serviceContext.getScopeGroupId(), classNameId, classPK, GetterUtil.getLong((Object)attachmentUrl.getId()), fileEntryId, false, null, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachmentUrl.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachmentUrl.getTitle()), AttachmentUtil._getJSON(cpDefinitionOptionRelService, cpDefinitionOptionValueRelService, cpOptionService, attachmentUrl.getOptions(), classPK, serviceContext.getCompanyId()), GetterUtil.getDouble((Object)attachmentUrl.getPriority()), type, serviceContext);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(long groupId, CPAttachmentFileEntryService cpAttachmentFileEntryService, CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, CPOptionService cpOptionService, UniqueFileNameProvider uniqueFileNameProvider, Attachment attachment, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        long fileEntryId = 0L;
        ServiceContext cloneServiceContext = (ServiceContext)serviceContext.clone();
        cloneServiceContext.setWorkflowAction(1);
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachment, uniqueFileNameProvider, cloneServiceContext);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachment.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachment.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachment.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachment.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachment.getExternalReferenceCode(), groupId, classNameId, classPK, GetterUtil.getLong((Object)attachment.getId()), fileEntryId, GetterUtil.get((Object)attachment.getCdnEnabled(), (boolean)false), GetterUtil.getString((String)attachment.getCdnURL()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachment.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachment.getTitle()), AttachmentUtil._getJSON(cpDefinitionOptionRelService, cpDefinitionOptionValueRelService, cpOptionService, attachment.getOptions(), classPK, serviceContext.getCompanyId()), GetterUtil.getDouble((Object)attachment.getPriority()), type, cloneServiceContext);
    }

    public static Map<Locale, String> getTitleMap(CPAttachmentFileEntry cpAttachmentFileEntry, Map<String, String> titleMap) throws PortalException {
        if (titleMap != null) {
            return LanguageUtils.getLocalizedMap(titleMap);
        }
        if (cpAttachmentFileEntry == null) {
            return null;
        }
        return cpAttachmentFileEntry.getTitleMap();
    }

    private static FileEntry _addFileEntry(File file, String contentType, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String uniqueFileName = uniqueFileNameProvider.provide(file.getName(), curFileName -> AttachmentUtil._exists(serviceContext.getScopeGroupId(), serviceContext.getUserId(), curFileName));
        if (Validator.isNull((String)contentType)) {
            contentType = MimeTypesUtil.getContentType((File)file);
        }
        uniqueFileName = AttachmentUtil._appendExtension(contentType, uniqueFileName);
        FileEntry fileEntry = DLAppServiceUtil.addFileEntry(null, (long)serviceContext.getScopeGroupId(), (long)0L, (String)uniqueFileName, (String)contentType, (String)uniqueFileName, (String)"", null, (String)"", (File)file, null, null, (ServiceContext)serviceContext);
        FileUtil.delete((File)file);
        return fileEntry;
    }

    private static String _appendExtension(String contentType, String uniqueFileName) {
        Iterator iterator;
        String extension = "";
        Set extensions = MimeTypesUtil.getExtensions((String)contentType);
        if (!extensions.isEmpty() && (iterator = extensions.iterator()).hasNext()) {
            extension = (String)iterator.next();
        }
        return uniqueFileName.concat(extension);
    }

    private static boolean _exists(long groupId, long userId, String curFileName) {
        try {
            FileEntry fileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FILE_NAME, (String)curFileName);
            return fileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }

    private static String _getJSON(CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, CPOptionService cpOptionService, Map<String, String> options, long classPK, long companyId) {
        if (options == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            jsonArray.put(() -> {
                CPOption cpOption = cpOptionService.fetchCPOption(companyId, (String)entry.getKey());
                if (cpOption == null) {
                    throw new NoSuchCPOptionException();
                }
                CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionRelService.fetchCPDefinitionOptionRel(classPK, cpOption.getCPOptionId());
                if (cpDefinitionOptionRel != null && cpDefinitionOptionRel.getCPDefinitionId() == classPK) {
                    CPDefinitionOptionValueRel cpDefinitionOptionValueRel = cpDefinitionOptionValueRelService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), (String)entry.getValue());
                    if (cpDefinitionOptionValueRel == null) {
                        throw new NoSuchCPDefinitionOptionValueRelException();
                    }
                    return JSONUtil.put((String)"key", (Object)cpDefinitionOptionRel.getKey()).put("value", JSONUtil.put((Object)cpDefinitionOptionValueRel.getKey()));
                }
                throw new NoSuchCPDefinitionOptionRelException();
            });
        }
        return jsonArray.toString();
    }
}

