/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuVirtualSettingsResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuVirtualSettingsResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku-virtual-settings.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, SkuVirtualSettingsResource.class})
public class SkuVirtualSettingsResourceImpl
extends BaseSkuVirtualSettingsResourceImpl
implements NestedFieldSupport {
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuVirtualSettingsDTOConverter)")
    private DTOConverter<CPInstance, SkuVirtualSettings> _skuVirtualSettingsDTOConverter;

    @Override
    public SkuVirtualSettings getSkuByExternalReferenceCodeSkuVirtualSettings(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return (SkuVirtualSettings)this._skuVirtualSettingsDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstance.getCPInstanceId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Sku.class, value="skuVirtualSettings")
    public SkuVirtualSettings getSkuIdSkuVirtualSettings(@NestedFieldId(value="id") Long id) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(id.longValue());
        return (SkuVirtualSettings)this._skuVirtualSettingsDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstance.getCPInstanceId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

