/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class SkuUtil {
    private static final Log _log = LogFactoryUtil.getLog(SkuUtil.class);

    public static CPInstance addOrUpdateCPInstance(CPInstanceService cpInstanceService, Sku sku, CPDefinition cpDefinition, CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, ServiceContext serviceContext) throws PortalException {
        long replacementCProductId = 0L;
        String replacementCPInstanceUuid = null;
        int discontinuedDateMonth = 0;
        int discontinuedDateDay = 0;
        int discontinuedDateYear = 0;
        if (GetterUtil.getBoolean((Object)sku.getDiscontinued())) {
            CPInstance discontinuedCPInstance = null;
            if (Validator.isNotNull((String)sku.getReplacementSkuExternalReferenceCode())) {
                discontinuedCPInstance = cpInstanceService.fetchByExternalReferenceCode(sku.getReplacementSkuExternalReferenceCode(), cpDefinition.getCompanyId());
            }
            long replacementSkuId = GetterUtil.getLong((Object)sku.getReplacementSkuId());
            if (discontinuedCPInstance == null && replacementSkuId > 0L) {
                discontinuedCPInstance = cpInstanceService.fetchCPInstance(replacementSkuId);
            }
            if (discontinuedCPInstance != null) {
                CPDefinition discontinuedCPDefinition = discontinuedCPInstance.getCPDefinition();
                replacementCProductId = discontinuedCPDefinition.getCProductId();
                replacementCPInstanceUuid = discontinuedCPInstance.getCPInstanceUuid();
            }
            if (sku.getDiscontinuedDate() != null) {
                Date discontinuedDate = GetterUtil.getDate((Object)sku.getDiscontinuedDate(), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"MM/dd/yyyy"), null);
                Calendar discontinuedCalendar = CalendarFactoryUtil.getCalendar((long)discontinuedDate.getTime());
                discontinuedDateDay = discontinuedCalendar.get(5);
                discontinuedDateMonth = discontinuedCalendar.get(2);
                discontinuedDateYear = discontinuedCalendar.get(1);
            }
        }
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (sku.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(sku.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (sku.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(sku.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        SkuSubscriptionConfiguration skuSubscriptionConfiguration = sku.getSkuSubscriptionConfiguration();
        boolean deliverySubscriptionEnable = false;
        int deliverySubscriptionLength = 1;
        long deliverySubscriptionMaxSubscriptionCycles = 0L;
        UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties = null;
        String deliverySubscriptionTypeValue = "";
        boolean overrideSubscriptionInfo = false;
        boolean subscriptionEnable = false;
        int subscriptionLength = 1;
        long subscriptionMaxSubscriptionCycles = 0L;
        UnicodeProperties subscriptionTypeSettingsUnicodeProperties = null;
        String subscriptionTypeValue = "";
        if (skuSubscriptionConfiguration != null) {
            SkuSubscriptionConfiguration.SubscriptionType subscriptionType;
            SkuSubscriptionConfiguration.DeliverySubscriptionType deliverySubscriptionType;
            deliverySubscriptionEnable = GetterUtil.getBoolean((Object)skuSubscriptionConfiguration.getDeliverySubscriptionEnable(), (boolean)deliverySubscriptionEnable);
            deliverySubscriptionLength = GetterUtil.getInteger((Object)skuSubscriptionConfiguration.getDeliverySubscriptionLength(), (int)deliverySubscriptionLength);
            deliverySubscriptionMaxSubscriptionCycles = GetterUtil.getLong((Object)skuSubscriptionConfiguration.getDeliverySubscriptionNumberOfLength(), (long)deliverySubscriptionMaxSubscriptionCycles);
            if (Validator.isNotNull((Object)skuSubscriptionConfiguration.getDeliverySubscriptionTypeSettings())) {
                deliverySubscriptionTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((Map)skuSubscriptionConfiguration.getDeliverySubscriptionTypeSettings(), (boolean)true).build();
            }
            if ((deliverySubscriptionType = skuSubscriptionConfiguration.getDeliverySubscriptionType()) != null) {
                deliverySubscriptionTypeValue = deliverySubscriptionType.getValue();
            }
            overrideSubscriptionInfo = GetterUtil.getBoolean((Object)skuSubscriptionConfiguration.getOverrideSubscriptionInfo(), (boolean)overrideSubscriptionInfo);
            subscriptionEnable = GetterUtil.getBoolean((Object)skuSubscriptionConfiguration.getEnable(), (boolean)subscriptionEnable);
            subscriptionLength = GetterUtil.getInteger((Object)skuSubscriptionConfiguration.getLength(), (int)subscriptionLength);
            subscriptionMaxSubscriptionCycles = GetterUtil.getLong((Object)skuSubscriptionConfiguration.getNumberOfLength(), (long)subscriptionMaxSubscriptionCycles);
            if (Validator.isNotNull((Object)skuSubscriptionConfiguration.getSubscriptionTypeSettings())) {
                subscriptionTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((Map)skuSubscriptionConfiguration.getSubscriptionTypeSettings(), (boolean)true).build();
            }
            if ((subscriptionType = skuSubscriptionConfiguration.getSubscriptionType()) != null) {
                subscriptionTypeValue = subscriptionType.getValue();
            }
        }
        return cpInstanceService.addOrUpdateCPInstance(sku.getExternalReferenceCode(), cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), sku.getSku(), sku.getGtin(), sku.getManufacturerPartNumber(), GetterUtil.get((Object)sku.getPurchasable(), (boolean)false), SkuUtil._getOptions(cpDefinitionOptionRelService, cpDefinitionOptionValueRelService, sku), GetterUtil.get((Object)sku.getWidth(), (double)0.0), GetterUtil.get((Object)sku.getHeight(), (double)0.0), GetterUtil.get((Object)sku.getDepth(), (double)0.0), GetterUtil.get((Object)sku.getWeight(), (double)0.0), (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.get((Object)sku.getCost(), (Number)BigDecimal.ZERO), GetterUtil.get((Object)sku.getPublished(), (boolean)false), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)sku.getNeverExpire(), (boolean)false), overrideSubscriptionInfo, subscriptionEnable, subscriptionLength, subscriptionTypeValue, subscriptionTypeSettingsUnicodeProperties, subscriptionMaxSubscriptionCycles, deliverySubscriptionEnable, deliverySubscriptionLength, deliverySubscriptionTypeValue, deliverySubscriptionTypeSettingsUnicodeProperties, deliverySubscriptionMaxSubscriptionCycles, sku.getUnspsc(), GetterUtil.get((Object)sku.getDiscontinued(), (boolean)false), replacementCPInstanceUuid, replacementCProductId, discontinuedDateMonth, discontinuedDateDay, discontinuedDateYear, serviceContext);
    }

    public static void updateCommercePriceEntries(CommercePriceEntryLocalService commercePriceEntryLocalService, CommercePriceListLocalService commercePriceListLocalService, ConfigurationProvider configurationProvider, CPInstance cpInstance, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws Exception {
        if (Objects.equals(SkuUtil._getCommercePricingConfigurationKey(configurationProvider), "v2.0")) {
            SkuUtil._updateCommercePriceEntry(commercePriceEntryLocalService, commercePriceListLocalService, cpInstance, "price-list", price, serviceContext);
            SkuUtil._updateCommercePriceEntry(commercePriceEntryLocalService, commercePriceListLocalService, cpInstance, "promotion", promoPrice, serviceContext);
        }
    }

    private static String _getCommercePricingConfigurationKey(ConfigurationProvider configurationProvider) throws Exception {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)configurationProvider.getConfiguration(CommercePricingConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.pricing.service.name"));
        return commercePricingConfiguration.commercePricingCalculationKey();
    }

    private static String _getCPDefinitionOptionRelKey(long optionId, CPDefinitionOptionRelService cpDefinitionOptionRelService) throws Exception {
        CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionRelService.fetchCPDefinitionOptionRel(optionId);
        if (cpDefinitionOptionRel != null) {
            return cpDefinitionOptionRel.getKey();
        }
        return null;
    }

    private static String _getCPDefinitionOptionValueRelKey(long optionValueId, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService) throws Exception {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = cpDefinitionOptionValueRelService.fetchCPDefinitionOptionValueRel(optionValueId);
        if (cpDefinitionOptionValueRel != null) {
            return cpDefinitionOptionValueRel.getKey();
        }
        return null;
    }

    private static String _getOptions(CPDefinitionOptionRelService cpDefinitionOptionRelService, CPDefinitionOptionValueRelService cpDefinitionOptionValueRelService, Sku sku) {
        SkuOption[] skuOptions = sku.getSkuOptions();
        if (skuOptions == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (SkuOption skuOption : skuOptions) {
            jsonArray.put(JSONUtil.put((String)"key", () -> {
                if (Validator.isNull((String)skuOption.getKey())) {
                    return SkuUtil._getCPDefinitionOptionRelKey(GetterUtil.getLong((Object)skuOption.getOptionId()), cpDefinitionOptionRelService);
                }
                try {
                    return SkuUtil._getCPDefinitionOptionRelKey(GetterUtil.getLongStrict((String)skuOption.getKey()), cpDefinitionOptionRelService);
                }
                catch (NumberFormatException numberFormatException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)numberFormatException);
                    }
                    return skuOption.getKey();
                }
            }).put("value", JSONUtil.put(() -> {
                if (Validator.isNull((String)skuOption.getValue())) {
                    return SkuUtil._getCPDefinitionOptionValueRelKey(GetterUtil.getLong((Object)skuOption.getOptionValueId()), cpDefinitionOptionValueRelService);
                }
                try {
                    return SkuUtil._getCPDefinitionOptionValueRelKey(GetterUtil.getLongStrict((String)skuOption.getValue()), cpDefinitionOptionValueRelService);
                }
                catch (NumberFormatException numberFormatException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)numberFormatException);
                    }
                    return skuOption.getValue();
                }
            })));
        }
        return jsonArray.toString();
    }

    private static void _updateCommercePriceEntry(CommercePriceEntryLocalService commercePriceEntryLocalService, CommercePriceListLocalService commercePriceListLocalService, CPInstance cpInstance, String type, BigDecimal price, ServiceContext serviceContext) throws Exception {
        CommercePriceList commercePriceList = commercePriceListLocalService.getCatalogBaseCommercePriceListByType(cpInstance.getGroupId(), type);
        CommercePriceEntry commercePriceEntry = commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid());
        serviceContext.setWorkflowAction(1);
        if (commercePriceEntry == null) {
            CPDefinition cpDefinition = cpInstance.getCPDefinition();
            commercePriceEntryLocalService.addCommercePriceEntry(null, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceList.getCommercePriceListId(), price, false, null, serviceContext);
        } else {
            commercePriceEntryLocalService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), price, commercePriceEntry.isPriceOnApplication(), null, serviceContext);
        }
    }
}

