/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuSubscriptionConfigurationDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuSubscriptionConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuSubscriptionConfigurationResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku-subscription-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, SkuSubscriptionConfigurationResource.class})
public class SkuSubscriptionConfigurationResourceImpl
extends BaseSkuSubscriptionConfigurationResourceImpl
implements NestedFieldSupport {
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private SkuSubscriptionConfigurationDTOConverter _skuSubscriptionConfigurationDTOConverter;

    @Override
    @NestedField(parentClass=Sku.class, value="skuSubscriptionConfiguration")
    public SkuSubscriptionConfiguration getIdSkuSubscriptionConfiguration(@NestedFieldId(value="id") Long id) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(id.longValue());
        return this._toSkuSubscriptionConfiguration(cpInstance.getCPInstanceId());
    }

    @Override
    public SkuSubscriptionConfiguration getSkuByExternalReferenceCodeSkuSubscriptionConfiguration(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find sku with external reference code: " + externalReferenceCode);
        }
        return this._toSkuSubscriptionConfiguration(cpInstance.getCPInstanceId());
    }

    private SkuSubscriptionConfiguration _toSkuSubscriptionConfiguration(Long cpInstanceId) throws Exception {
        return this._skuSubscriptionConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, (Object)cpInstanceId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

