/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.type.virtual.constants.VirtualCPTypeConstants;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.internal.util.FileEntryUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProductVirtualSettingsUtil {
    public static CPDefinitionVirtualSetting addOrUpdateProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        if (cpDefinitionVirtualSetting == null) {
            return ProductVirtualSettingsUtil._addProductVirtualSettings(cpDefinition, productVirtualSettings, cpDefinitionVirtualSettingService, uniqueFileNameProvider, serviceContext);
        }
        return ProductVirtualSettingsUtil._updateProductVirtualSettings(cpDefinitionVirtualSetting, productVirtualSettings, cpDefinitionVirtualSettingService, uniqueFileNameProvider, serviceContext);
    }

    private static CPDefinitionVirtualSetting _addProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String attachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getUrl());
        long attachmentFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getAttachment(), attachmentURL, uniqueFileNameProvider, serviceContext);
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample());
        if (useSample) {
            sampleAttachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getSampleUrl());
            sampleFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentURL, uniqueFileNameProvider, serviceContext);
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.getBoolean((Object)productVirtualSettings.getTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
        }
        return cpDefinitionVirtualSettingService.addCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), attachmentFileEntryId, attachmentURL, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)0)), TimeUnit.DAYS.toMillis(GetterUtil.getLong((Object)productVirtualSettings.getDuration())), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, serviceContext);
    }

    private static int _getActivationStatus(int activationStatus) {
        if (ArrayUtil.contains((int[])VirtualCPTypeConstants.ACTIVATION_STATUSES, (int)activationStatus)) {
            return activationStatus;
        }
        return 0;
    }

    private static CPDefinitionVirtualSetting _updateProductVirtualSettings(CPDefinitionVirtualSetting cpDefinitionVirtualSetting, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        Long duration;
        long attachmentFileEntryId = 0L;
        String attachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getUrl());
        if (Validator.isNull((String)attachmentURL)) {
            if (Validator.isNull((String)productVirtualSettings.getAttachment())) {
                attachmentURL = cpDefinitionVirtualSetting.getUrl();
            } else {
                attachmentFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getAttachment(), attachmentURL, uniqueFileNameProvider, serviceContext);
            }
            if (attachmentFileEntryId == 0L) {
                attachmentFileEntryId = cpDefinitionVirtualSetting.getFileEntryId();
            }
        }
        if ((duration = productVirtualSettings.getDuration()) != null) {
            duration = TimeUnit.DAYS.toMillis(duration);
        }
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample(), (boolean)cpDefinitionVirtualSetting.isUseSample());
        if (useSample && Validator.isNull((String)(sampleAttachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getSampleUrl())))) {
            if (Validator.isNull((String)productVirtualSettings.getSampleAttachment())) {
                sampleAttachmentURL = cpDefinitionVirtualSetting.getSampleUrl();
            } else {
                sampleFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentURL, uniqueFileNameProvider, serviceContext);
            }
            if (sampleFileEntryId == 0L) {
                sampleFileEntryId = cpDefinitionVirtualSetting.getSampleFileEntryId();
            }
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.get((Object)productVirtualSettings.getTermsOfUseRequired(), (boolean)cpDefinitionVirtualSetting.isTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
            if (termsOfUseContentMap == null && termsOfUseJournalArticleId == 0L) {
                JournalArticle termsOfUseJournalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                if (termsOfUseJournalArticle != null) {
                    termsOfUseJournalArticleId = termsOfUseJournalArticle.getResourcePrimKey();
                } else {
                    termsOfUseContentMap = cpDefinitionVirtualSetting.getTermsOfUseContentMap();
                }
            }
        }
        return cpDefinitionVirtualSettingService.updateCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), attachmentFileEntryId, attachmentURL, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)cpDefinitionVirtualSetting.getActivationStatus())), GetterUtil.getLong((Object)duration, (long)cpDefinitionVirtualSetting.getDuration()), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages(), (int)cpDefinitionVirtualSetting.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, serviceContext);
    }

    private static String _validateURL(String value) throws Exception {
        if (Validator.isNotNull((String)value)) {
            URL url = new URL(value);
            return url.toString();
        }
        return null;
    }
}

