/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuSubscriptionConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Crescenzo Rega
 */
@Component(
	property = "dto.class.name=SkuSubscriptionConfiguration",
	service = {
		DTOConverter.class, SkuSubscriptionConfigurationDTOConverter.class
	}
)
public class SkuSubscriptionConfigurationDTOConverter
	implements DTOConverter<CPInstance, SkuSubscriptionConfiguration> {

	@Override
	public String getContentType() {
		return SkuSubscriptionConfiguration.class.getSimpleName();
	}

	@Override
	public SkuSubscriptionConfiguration toDTO(
			DTOConverterContext dtoConverterContext)
		throws Exception {

		CPInstance cpInstance = _cpInstanceService.getCPInstance(
			(Long)dtoConverterContext.getId());

		return new SkuSubscriptionConfiguration() {
			{
				deliverySubscriptionEnable =
					cpInstance.isDeliverySubscriptionEnabled();
				deliverySubscriptionLength =
					cpInstance.getDeliverySubscriptionLength();
				deliverySubscriptionNumberOfLength =
					cpInstance.getDeliveryMaxSubscriptionCycles();
				deliverySubscriptionType = DeliverySubscriptionType.create(
					cpInstance.getDeliverySubscriptionType());
				deliverySubscriptionTypeSettings =
					cpInstance.
						getDeliverySubscriptionTypeSettingsUnicodeProperties();
				enable = cpInstance.isSubscriptionEnabled();
				length = cpInstance.getSubscriptionLength();
				numberOfLength = cpInstance.getMaxSubscriptionCycles();
				overrideSubscriptionInfo =
					cpInstance.isOverrideSubscriptionInfo();
				subscriptionType = SubscriptionType.create(
					cpInstance.getSubscriptionType());
				subscriptionTypeSettings =
					cpInstance.getSubscriptionTypeSettingsUnicodeProperties();
			}
		};
	}

	@Reference
	private CPInstanceService _cpInstanceService;

}