/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.exception.CPDefinitionProductTypeNameException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.grouped.model.CPDefinitionGroupedEntry;
import com.liferay.commerce.product.type.grouped.service.CPDefinitionGroupedEntryService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.LinkedProduct;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.LinkedProductDTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.type.grouped.model.CPDefinitionGroupedEntry"}, service={DTOConverter.class, LinkedProductDTOConverter.class})
public class LinkedProductDTOConverter
implements DTOConverter<CPDefinitionGroupedEntry, LinkedProduct> {
    @Reference
    private CPDefinitionGroupedEntryService _cpDefinitionGroupedEntryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;

    public String getContentType() {
        return LinkedProduct.class.getSimpleName();
    }

    public LinkedProduct toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        LinkedProductDTOConverterContext linkedProductDTOConverterContext = (LinkedProductDTOConverterContext)dtoConverterContext;
        final CPDefinition cpDefinition = this._getCPDefinition((Long)linkedProductDTOConverterContext.getId(), linkedProductDTOConverterContext.getProductTypeName());
        final CProduct cProduct = cpDefinition.getCProduct();
        return new LinkedProduct(){
            {
                this.productExternalReferenceCode = cProduct.getExternalReferenceCode();
                this.productId = cProduct.getCProductId();
                this.type = cpDefinition.getProductTypeName();
            }
        };
    }

    private CPDefinition _getCPDefinition(long id, String productTypeName) throws Exception {
        if ("diagram".equals(productTypeName)) {
            CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(id);
            return this._cpDefinitionService.getCPDefinition(csDiagramEntry.getCPDefinitionId());
        }
        if ("grouped".equals(productTypeName)) {
            CPDefinitionGroupedEntry cpDefinitionGroupedEntry = this._cpDefinitionGroupedEntryService.getCPDefinitionGroupedEntry(id);
            return this._cpDefinitionService.getCPDefinition(cpDefinitionGroupedEntry.getCPDefinitionId());
        }
        throw new CPDefinitionProductTypeNameException();
    }
}

