/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import java.util.Locale;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=ProductTaxConfiguration",
	service = DTOConverter.class
)
public class ProductTaxConfigurationDTOConverter
	implements DTOConverter<CPDefinition, ProductTaxConfiguration> {

	@Override
	public String getContentType() {
		return ProductTaxConfiguration.class.getSimpleName();
	}

	@Override
	public ProductTaxConfiguration toDTO(
			DTOConverterContext dtoConverterContext)
		throws Exception {

		CPDefinition cpDefinition = _cpDefinitionService.getCPDefinition(
			(Long)dtoConverterContext.getId());

		CPTaxCategory cpTaxCategory = cpDefinition.getCPTaxCategory();

		return new ProductTaxConfiguration() {
			{
				id = cpDefinition.getCPTaxCategoryId();
				taxable = !cpDefinition.isTaxExempt();
				taxCategory = _getTaxCategory(
					cpTaxCategory, dtoConverterContext.getLocale());
			}
		};
	}

	private String _getTaxCategory(CPTaxCategory cpTaxCategory, Locale locale) {
		if (cpTaxCategory == null) {
			return null;
		}

		return cpTaxCategory.getName(locale);
	}

	@Reference
	private CPDefinitionService _cpDefinitionService;

}