/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.type.virtual.constants.VirtualCPTypeConstants;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ProductVirtualSettingsUtil {
    private static final String _TEMP_FILE_NAME = ProductVirtualSettingsUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ProductVirtualSettingsUtil.class);

    public static CPDefinitionVirtualSetting addOrUpdateProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        if (cpDefinitionVirtualSetting == null) {
            return ProductVirtualSettingsUtil._addProductVirtualSettings(cpDefinition, productVirtualSettings, cpDefinitionVirtualSettingService, uniqueFileNameProvider, serviceContext);
        }
        return ProductVirtualSettingsUtil._updateProductVirtualSettings(cpDefinitionVirtualSetting, productVirtualSettings, cpDefinitionVirtualSettingService, uniqueFileNameProvider, serviceContext);
    }

    private static FileEntry _addFileEntry(File file, String contentType, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String uniqueFileName = uniqueFileNameProvider.provide(file.getName(), curFileName -> ProductVirtualSettingsUtil._exists(serviceContext.getScopeGroupId(), serviceContext.getUserId(), curFileName));
        if (Validator.isNull((String)contentType)) {
            contentType = MimeTypesUtil.getContentType((File)file);
        }
        uniqueFileName = ProductVirtualSettingsUtil._appendExtension(contentType, uniqueFileName);
        FileEntry fileEntry = DLAppServiceUtil.addFileEntry(null, (long)serviceContext.getScopeGroupId(), (long)0L, (String)uniqueFileName, (String)contentType, (String)uniqueFileName, (String)"", null, (String)"", (File)file, null, null, (ServiceContext)serviceContext);
        FileUtil.delete((File)file);
        return fileEntry;
    }

    private static CPDefinitionVirtualSetting _addProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String attachmentUrl = ProductVirtualSettingsUtil._validateUrl(productVirtualSettings.getUrl());
        long attachmentFileEntryId = ProductVirtualSettingsUtil._getFileEntryId(productVirtualSettings.getAttachment(), attachmentUrl, uniqueFileNameProvider, serviceContext);
        String sampleAttachmentUrl = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample());
        if (useSample) {
            sampleAttachmentUrl = ProductVirtualSettingsUtil._validateUrl(productVirtualSettings.getSampleUrl());
            sampleFileEntryId = ProductVirtualSettingsUtil._getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentUrl, uniqueFileNameProvider, serviceContext);
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.getBoolean((Object)productVirtualSettings.getTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
        }
        return cpDefinitionVirtualSettingService.addCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), attachmentFileEntryId, attachmentUrl, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)0)), TimeUnit.DAYS.toMillis(GetterUtil.getLong((Object)productVirtualSettings.getDuration())), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentUrl, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, serviceContext);
    }

    private static String _appendExtension(String contentType, String uniqueFileName) {
        Iterator iterator;
        String extension = "";
        Set extensions = MimeTypesUtil.getExtensions((String)contentType);
        if (!extensions.isEmpty() && (iterator = extensions.iterator()).hasNext()) {
            extension = (String)iterator.next();
        }
        return uniqueFileName.concat(extension);
    }

    private static boolean _exists(long groupId, long userId, String curFileName) {
        try {
            FileEntry fileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FILE_NAME, (String)curFileName);
            return fileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }

    private static int _getActivationStatus(int activationStatus) {
        if (ArrayUtil.contains((int[])VirtualCPTypeConstants.ACTIVATION_STATUSES, (int)activationStatus)) {
            return activationStatus;
        }
        return 0;
    }

    private static long _getFileEntryId(String attachment, String url, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((String)attachment) && Validator.isNull((String)url)) {
            serviceContext.setExpandoBridgeAttributes(new HashMap());
            FileEntry fileEntry = ProductVirtualSettingsUtil._addFileEntry(FileUtil.createTempFile((byte[])Base64.decode((String)attachment)), null, uniqueFileNameProvider, serviceContext);
            return fileEntry.getFileEntryId();
        }
        return 0L;
    }

    private static CPDefinitionVirtualSetting _updateProductVirtualSettings(CPDefinitionVirtualSetting cpDefinitionVirtualSetting, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        Long duration;
        long attachmentFileEntryId = 0L;
        String attachmentUrl = ProductVirtualSettingsUtil._validateUrl(productVirtualSettings.getUrl());
        if (Validator.isNull((String)attachmentUrl)) {
            if (Validator.isNull((String)productVirtualSettings.getAttachment())) {
                attachmentUrl = cpDefinitionVirtualSetting.getUrl();
            } else {
                attachmentFileEntryId = ProductVirtualSettingsUtil._getFileEntryId(productVirtualSettings.getAttachment(), attachmentUrl, uniqueFileNameProvider, serviceContext);
            }
            if (attachmentFileEntryId == 0L) {
                attachmentFileEntryId = cpDefinitionVirtualSetting.getFileEntryId();
            }
        }
        if ((duration = productVirtualSettings.getDuration()) != null) {
            duration = TimeUnit.DAYS.toMillis(duration);
        }
        String sampleAttachmentUrl = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample(), (boolean)cpDefinitionVirtualSetting.isUseSample());
        if (useSample && Validator.isNull((String)(sampleAttachmentUrl = ProductVirtualSettingsUtil._validateUrl(productVirtualSettings.getSampleUrl())))) {
            if (Validator.isNull((String)productVirtualSettings.getSampleAttachment())) {
                sampleAttachmentUrl = cpDefinitionVirtualSetting.getSampleUrl();
            } else {
                sampleFileEntryId = ProductVirtualSettingsUtil._getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentUrl, uniqueFileNameProvider, serviceContext);
            }
            if (sampleFileEntryId == 0L) {
                sampleFileEntryId = cpDefinitionVirtualSetting.getSampleFileEntryId();
            }
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.get((Object)productVirtualSettings.getTermsOfUseRequired(), (boolean)cpDefinitionVirtualSetting.isTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
            if (termsOfUseContentMap == null && termsOfUseJournalArticleId == 0L) {
                JournalArticle termsOfUseJournalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                if (termsOfUseJournalArticle != null) {
                    termsOfUseJournalArticleId = termsOfUseJournalArticle.getResourcePrimKey();
                } else {
                    termsOfUseContentMap = cpDefinitionVirtualSetting.getTermsOfUseContentMap();
                }
            }
        }
        return cpDefinitionVirtualSettingService.updateCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), attachmentFileEntryId, attachmentUrl, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)cpDefinitionVirtualSetting.getActivationStatus())), GetterUtil.getLong((Object)duration, (long)cpDefinitionVirtualSetting.getDuration()), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages(), (int)cpDefinitionVirtualSetting.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentUrl, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, serviceContext);
    }

    private static String _validateUrl(String value) throws Exception {
        if (Validator.isNotNull((String)value)) {
            URL url = new URL(value);
            return url.toString();
        }
        return null;
    }
}

