/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings"}, service={DTOConverter.class, ProductVirtualSettingsDTOConverter.class})
public class ProductVirtualSettingsDTOConverter
implements DTOConverter<CPDefinition, ProductVirtualSettings> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private Language _language;

    public String getContentType() {
        return ProductVirtualSettings.class.getSimpleName();
    }

    public ProductVirtualSettings toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        if (!"virtual".equals(cpDefinition.getProductTypeName())) {
            return null;
        }
        final CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        if (cpDefinitionVirtualSetting == null) {
            return null;
        }
        return new ProductVirtualSettings(){
            {
                this.activationStatus = cpDefinitionVirtualSetting.getActivationStatus();
                this.duration = TimeUnit.MILLISECONDS.toDays(cpDefinitionVirtualSetting.getDuration());
                this.maxUsages = cpDefinitionVirtualSetting.getMaxUsages();
                this.sampleUrl = cpDefinitionVirtualSetting.getSampleUrl();
                this.termsOfUseContent = LanguageUtils.getLanguageIdMap((Map)cpDefinitionVirtualSetting.getTermsOfUseContentMap());
                this.termsOfUseRequired = cpDefinitionVirtualSetting.isTermsOfUseRequired();
                this.url = cpDefinitionVirtualSetting.getUrl();
                this.useSample = cpDefinitionVirtualSetting.isUseSample();
                this.setActivationStatusInfo(() -> {
                    final String orderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)cpDefinitionVirtualSetting.getActivationStatus());
                    return new Status(){
                        {
                            this.code = cpDefinitionVirtualSetting.getActivationStatus();
                            this.label = orderStatusLabel;
                            this.label_i18n = ProductVirtualSettingsDTOConverter.this._language.get(dtoConverterContext.getLocale(), orderStatusLabel);
                        }
                    };
                });
                this.setSampleSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getSampleFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return ProductVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductSampleURL(Long.MIN_VALUE, cpDefinition.getCPDefinitionId(), fileEntry.getFileEntryId());
                });
                this.setSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return ProductVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(Long.MIN_VALUE, cpDefinition.getCPDefinitionId(), fileEntry.getFileEntryId());
                });
                this.setTermsOfUseJournalArticleId(() -> {
                    JournalArticle journalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                    if (journalArticle == null) {
                        return null;
                    }
                    return journalArticle.getResourcePrimKey();
                });
            }
        };
    }
}

