/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.SkuHelper;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.SkuEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, SkuResource.class})
public class SkuResourceImpl
extends BaseSkuResourceImpl
implements NestedFieldSupport {
    private static final EntityModel _entityModel = new SkuEntityModel();
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuDTOConverter)")
    private DTOConverter<CPInstance, Sku> _skuDTOConverter;
    @Reference
    private SkuHelper _skuHelper;

    @Override
    public Response deleteSku(Long id) throws Exception {
        this._cpInstanceService.deleteCPInstance(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteSkuByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        this._cpInstanceService.deleteCPInstance(cpInstance.getCPInstanceId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<Sku> getProductByExternalReferenceCodeSkusPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._skuHelper.getSkusPage(cpDefinition.getCProductId(), this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="skus")
    public Page<Sku> getProductIdSkusPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        return this._skuHelper.getSkusPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public Sku getSku(Long id) throws Exception {
        return this._toSku(GetterUtil.getLong((Object)id));
    }

    @Override
    public Sku getSkuByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return this._toSku(cpInstance.getCPInstanceId());
    }

    @Override
    public Page<Sku> getSkusPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._skuHelper.getSkusPage(this.contextCompany.getCompanyId(), search, filter, pagination, sorts, (UnsafeFunction<Document, Sku, Exception>)((UnsafeFunction)document -> this._toSku(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public Sku patchSku(Long id, Sku sku) throws Exception {
        this._updateSKU(this._cpInstanceService.getCPInstance(id.longValue()), sku);
        return this._toSku(id);
    }

    @Override
    public Sku patchSkuByExternalReferenceCode(String externalReferenceCode, Sku sku) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        this._updateSKU(cpInstance, sku);
        return this._toSku(cpInstance.getCPInstanceId());
    }

    @Override
    public Sku postProductByExternalReferenceCodeSku(String externalReferenceCode, Sku sku) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateSKU(cpDefinition, sku);
    }

    @Override
    public Sku postProductIdSku(Long id, Sku sku) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateSKU(cpDefinition, sku);
    }

    private Sku _addOrUpdateSKU(CPDefinition cpDefinition, Sku sku) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(sku);
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        CPInstance cpInstance = SkuUtil.addOrUpdateCPInstance(this._cpInstanceService, sku, cpDefinition, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, serviceContext);
        serviceContext.setExpandoBridgeAttributes(null);
        SkuUtil.updateCommercePriceEntries(this._commercePriceEntryLocalService, this._commercePriceListLocalService, this._configurationProvider, cpInstance, (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)cpInstance.getPrice()), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)cpInstance.getPromoPrice()), serviceContext);
        return this._toSku(cpInstance.getCPInstanceId());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(Sku sku) {
        return CustomFieldsUtil.toMap(CPInstance.class.getName(), this.contextCompany.getCompanyId(), sku.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Sku _toSku(Long cpInstanceId) throws Exception {
        return (Sku)this._skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstanceId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Sku _updateSKU(CPInstance cpInstance, Sku sku) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpInstance.getGroupId());
        Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(sku);
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        long replacementCProductId = cpInstance.getReplacementCProductId();
        String replacementCPInstanceUuid = cpInstance.getReplacementCPInstanceUuid();
        if (GetterUtil.getBoolean((Object)sku.getDiscontinued())) {
            CPInstance discontinuedCPInstance = null;
            if (Validator.isNotNull((String)sku.getReplacementSkuExternalReferenceCode())) {
                discontinuedCPInstance = this._cpInstanceService.fetchByExternalReferenceCode(sku.getReplacementSkuExternalReferenceCode(), this.contextCompany.getCompanyId());
            }
            if (discontinuedCPInstance == null && GetterUtil.getLong((Object)sku.getReplacementSkuId()) > 0L) {
                discontinuedCPInstance = this._cpInstanceService.fetchCPInstance(sku.getReplacementSkuId().longValue());
            }
            if (discontinuedCPInstance != null) {
                CPDefinition cpDefinition = discontinuedCPInstance.getCPDefinition();
                replacementCProductId = cpDefinition.getCProductId();
                replacementCPInstanceUuid = discontinuedCPInstance.getCPInstanceUuid();
            }
        }
        int discontinuedDateMonth = 0;
        int discontinuedDateDay = 0;
        int discontinuedDateYear = 0;
        if (cpInstance.getDiscontinuedDate() != null) {
            DateConfig discontinuedDateConfig = new DateConfig(DateConfigUtil.convertDateToCalendar(GetterUtil.getDate((Object)sku.getDiscontinuedDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpInstance.getDiscontinuedDate())));
            discontinuedDateMonth = discontinuedDateConfig.getMonth();
            discontinuedDateDay = discontinuedDateConfig.getDay();
            discontinuedDateYear = discontinuedDateConfig.getYear();
        }
        DateConfig displayDateConfig = new DateConfig(DateConfigUtil.convertDateToCalendar(GetterUtil.getDate((Object)sku.getDisplayDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpInstance.getDisplayDate())));
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        if (cpInstance.getExpirationDate() != null) {
            DateConfig expirationDateConfig = new DateConfig(DateConfigUtil.convertDateToCalendar(GetterUtil.getDate((Object)sku.getExpirationDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpInstance.getExpirationDate())));
            expirationDateMonth = expirationDateConfig.getMonth();
            expirationDateDay = expirationDateConfig.getDay();
            expirationDateYear = expirationDateConfig.getYear();
            expirationDateHour = expirationDateConfig.getHour();
            expirationDateMinute = expirationDateConfig.getMinute();
        }
        cpInstance = this._cpInstanceService.updateCPInstance(cpInstance.getExternalReferenceCode(), cpInstance.getCPInstanceId(), GetterUtil.get((String)sku.getSku(), (String)cpInstance.getSku()), GetterUtil.get((String)sku.getGtin(), (String)cpInstance.getGtin()), GetterUtil.get((String)sku.getManufacturerPartNumber(), (String)cpInstance.getManufacturerPartNumber()), GetterUtil.get((Object)sku.getPurchasable(), (boolean)cpInstance.isPurchasable()), GetterUtil.get((Object)sku.getWidth(), (double)cpInstance.getWidth()), GetterUtil.get((Object)sku.getHeight(), (double)cpInstance.getHeight()), GetterUtil.get((Object)sku.getDepth(), (double)cpInstance.getDepth()), GetterUtil.get((Object)sku.getWeight(), (double)cpInstance.getWeight()), (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)cpInstance.getPrice()), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)cpInstance.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)sku.getCost(), (Number)cpInstance.getCost()), GetterUtil.get((Object)sku.getPublished(), (boolean)cpInstance.isPublished()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, GetterUtil.get((Object)sku.getNeverExpire(), (cpInstance.getExpirationDate() == null ? 1 : 0) != 0), GetterUtil.getString((String)sku.getUnspsc(), (String)cpInstance.getUnspsc()), GetterUtil.getBoolean((Object)sku.getDiscontinued(), (boolean)cpInstance.isDiscontinued()), replacementCPInstanceUuid, replacementCProductId, discontinuedDateMonth, discontinuedDateDay, discontinuedDateYear, serviceContext);
        serviceContext.setExpandoBridgeAttributes(null);
        SkuUtil.updateCommercePriceEntries(this._commercePriceEntryLocalService, this._commercePriceListLocalService, this._configurationProvider, cpInstance, (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)cpInstance.getPrice()), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)cpInstance.getPromoPrice()), serviceContext);
        return this._toSku(cpInstance.getCPInstanceId());
    }
}

