/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.CatalogEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCatalogResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/catalog.properties"}, scope=ServiceScope.PROTOTYPE, service={CatalogResource.class, NestedFieldSupport.class})
public class CatalogResourceImpl
extends BaseCatalogResourceImpl
implements NestedFieldSupport {
    private static final EntityModel _entityModel = new CatalogEntityModel();
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.CatalogDTOConverter)")
    private DTOConverter<CommerceCatalog, Catalog> _catalogDTOConverter;
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCatalog(Long id) throws Exception {
        this._commerceCatalogService.deleteCommerceCatalog(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Catalog getCatalog(Long id) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalog(id.longValue());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find Catalog with ID: " + id);
        }
        return this._toCatalog(commerceCatalog);
    }

    @Override
    public Catalog getCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        return this._toCatalog(commerceCatalog);
    }

    @Override
    public Page<Catalog> getCatalogsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceCatalog.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toCatalog(this._commerceCatalogService.getCommerceCatalog(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Catalog getProductByExternalReferenceCodeCatalog(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toCatalog(cpDefinition.getCommerceCatalog());
    }

    @Override
    @NestedField(parentClass=Product.class, value="catalog")
    public Catalog getProductIdCatalog(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._toCatalog(cpDefinition.getCommerceCatalog());
    }

    @Override
    public Response patchCatalog(Long id, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.getCommerceCatalog(id.longValue());
        this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), catalog.getName(), GetterUtil.get((String)catalog.getCurrencyCode(), (String)commerceCatalog.getCommerceCurrencyCode()), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchCatalogByExternalReferenceCode(String externalReferenceCode, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Catalog postCatalog(Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(catalog.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        commerceCatalog = commerceCatalog == null ? this._commerceCatalogService.addCommerceCatalog(catalog.getExternalReferenceCode(), catalog.getName(), catalog.getCurrencyCode(), catalog.getDefaultLanguageId(), this._serviceContextHelper.getServiceContext()) : this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), catalog.getName(), GetterUtil.get((String)catalog.getCurrencyCode(), (String)commerceCatalog.getCommerceCurrencyCode()), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
        return this._toCatalog(commerceCatalog);
    }

    private Map<String, Map<String, String>> _getActions(CommerceCatalog commerceCatalog) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceCatalog.getCommerceCatalogId(), "deleteCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).put((Object)"get", this.addAction("VIEW", commerceCatalog.getCommerceCatalogId(), "getCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).put((Object)"update", this.addAction("UPDATE", commerceCatalog.getCommerceCatalogId(), "patchCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).build();
    }

    private Catalog _toCatalog(CommerceCatalog commerceCatalog) throws Exception {
        return (Catalog)this._catalogDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceCatalog), this._dtoConverterRegistry, (Object)commerceCatalog.getCommerceCatalogId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

