/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupRelService;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.configuration.CProductVersionConfiguration;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeRegistry;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramSettingService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Diagram;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Pin;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductAccountGroup;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductChannel;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductHelper;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.ProductEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.AttachmentUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.DiagramUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.MappedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.PinUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionValueUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductShippingConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSpecificationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSubscriptionConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductTaxConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.RelatedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductResource.class})
public class ProductResourceImpl
extends BaseProductResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(ProductResourceImpl.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceAccountGroupRelService _commerceAccountGroupRelService;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private CPTypeRegistry _cpTypeRegistry;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;
    @Reference
    private CSDiagramPinService _csDiagramPinService;
    @Reference
    private CSDiagramSettingService _csDiagramSettingService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductDTOConverter)")
    private DTOConverter<CPDefinition, Product> _productDTOConverter;
    @Reference
    private ProductHelper _productHelper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public void delete(Collection<Product> products, Map<String, Serializable> parameters) throws Exception {
        for (Product product : products) {
            this.deleteProduct(product.getProductId());
        }
    }

    @Override
    public void deleteProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByExternalReferenceCodeByVersion(String externalReferenceCode, Integer version) throws Exception {
        CProduct cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cProduct == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(cProduct.getCProductId(), version.intValue());
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByVersion(Long id, Integer version) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(id.longValue(), version.intValue());
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return new ProductEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(CPDefinition.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public Product getProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByExternalReferenceCodeByVersion(String externalReferenceCode, Integer version) throws Exception {
        CProduct cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cProduct == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(cProduct.getCProductId(), version.intValue());
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByVersion(Long id, Integer version) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(id.longValue(), version.intValue());
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Page<Product> getProductsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._productHelper.getProductsPage(this.contextCompany.getCompanyId(), search, filter, pagination, sorts, (UnsafeFunction<Document, Product, Exception>)((UnsafeFunction)document -> this._toProduct(GetterUtil.getLong((String)document.get("entryClassPK")))), this.contextAcceptLanguage.getPreferredLocale());
    }

    @Override
    public Response patchProduct(Long id, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProduct(cpDefinition, product);
        if (!Validator.isBlank((String)product.getExternalReferenceCode())) {
            this._cpDefinitionService.updateExternalReferenceCode(product.getExternalReferenceCode(), cpDefinition.getCPDefinitionId());
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductByExternalReferenceCode(String externalReferenceCode, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        int productStatus = GetterUtil.getInteger((Object)product.getProductStatus());
        if (productStatus == 2) {
            serviceContext.setWorkflowAction(2);
        }
        this._updateProduct(cpDefinition, product);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Product postProduct(Product product) throws Exception {
        CPDefinition cpDefinition = this._addOrUpdateProduct(product);
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product postProductByExternalReferenceCodeClone(String externalReferenceCode, String catalogExternalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (catalogExternalReferenceCode != null) {
            commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByExternalReferenceCode(catalogExternalReferenceCode, this.contextCompany.getCompanyId());
        }
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException();
        }
        cpDefinition = this._cpDefinitionService.copyCPDefinition(cpDefinition.getCPDefinitionId(), commerceCatalog.getGroupId(), 2);
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product postProductClone(Long id, Long catalogId) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (catalogId != null) {
            commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(catalogId.longValue());
        }
        cpDefinition = this._cpDefinitionService.cloneCPDefinition(cpDefinition.getCPDefinitionId(), commerceCatalog.getGroupId(), this._serviceContextHelper.getServiceContext(commerceCatalog.getGroupId()));
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void update(Collection<Product> products, Map<String, Serializable> parameters) throws Exception {
        for (Product product : products) {
            this.patchProduct(product.getProductId(), product);
        }
    }

    private CPDefinition _addOrUpdateProduct(Product product) throws Exception {
        Map expando;
        int productStatus;
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(product.getCatalogId().longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceCatalog.getGroupId());
        String[] assetTagNames = new String[]{};
        if (product.getTags() != null) {
            assetTagNames = product.getTags();
        }
        serviceContext.setAssetTagNames(assetTagNames);
        Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(product);
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)product.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)product.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        ProductShippingConfiguration shippingConfiguration = this._getProductShippingConfiguration(product);
        ProductSubscriptionConfiguration subscriptionConfiguration = this._getProductSubscriptionConfiguration(product);
        ProductTaxConfiguration taxConfiguration = this._getProductTaxConfiguration(product);
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(product.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        Category[] categories = product.getCategories();
        if (categories != null) {
            ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
            for (Category category : categories) {
                if (category.getId() == null) continue;
                assetCategoryIds.add(category.getId());
            }
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray(assetCategoryIds));
        } else if (cpDefinition != null) {
            serviceContext.setAssetCategoryIds(this._assetCategoryLocalService.getCategoryIds(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()));
        }
        Map nameMap = product.getName();
        if (cpDefinition != null && nameMap == null) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
        }
        Map shortDescriptionMap = product.getShortDescription();
        if (cpDefinition != null && shortDescriptionMap == null) {
            shortDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
        }
        Map descriptionMap = product.getDescription();
        if (cpDefinition != null && descriptionMap == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
        }
        Map urlTitleMap = product.getUrls();
        if (cpDefinition != null && urlTitleMap == null) {
            urlTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getUrlTitleMap());
        }
        Map metaTitleMap = product.getMetaTitle();
        if (cpDefinition != null && metaTitleMap == null) {
            metaTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
        }
        Map metaDescriptionMap = product.getMetaDescription();
        if (cpDefinition != null && metaDescriptionMap == null) {
            metaDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
        }
        Map metaKeywordsMap = product.getMetaKeyword();
        if (cpDefinition != null && metaKeywordsMap == null) {
            metaKeywordsMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
        }
        boolean ignoreSKUCombinations = true;
        if (cpDefinition != null) {
            ignoreSKUCombinations = cpDefinition.isIgnoreSKUCombinations();
        }
        if ((productStatus = GetterUtil.getInteger((Object)product.getProductStatus())) != 0) {
            serviceContext.setWorkflowAction(2);
        }
        cpDefinition = this._cpDefinitionService.addOrUpdateCPDefinition(product.getExternalReferenceCode(), commerceCatalog.getGroupId(), LanguageUtils.getLocalizedMap((Map)nameMap), LanguageUtils.getLocalizedMap((Map)shortDescriptionMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), LanguageUtils.getLocalizedMap((Map)urlTitleMap), LanguageUtils.getLocalizedMap((Map)metaTitleMap), LanguageUtils.getLocalizedMap((Map)metaDescriptionMap), LanguageUtils.getLocalizedMap((Map)metaKeywordsMap), product.getProductType(), ignoreSKUCombinations, GetterUtil.getBoolean((Object)shippingConfiguration.getShippable(), (boolean)true), GetterUtil.getBoolean((Object)shippingConfiguration.getFreeShipping(), (boolean)true), GetterUtil.getBoolean((Object)shippingConfiguration.getShippingSeparately(), (boolean)true), GetterUtil.getDouble((Object)shippingConfiguration.getShippingExtraPrice()), GetterUtil.getDouble((Object)shippingConfiguration.getWidth()), GetterUtil.getDouble((Object)shippingConfiguration.getHeight()), GetterUtil.getDouble((Object)shippingConfiguration.getDepth()), GetterUtil.getDouble((Object)shippingConfiguration.getWeight()), GetterUtil.getLong((Object)taxConfiguration.getId()), ProductUtil.isTaxExempt(null, taxConfiguration), false, null, true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)product.getNeverExpire(), (boolean)true), product.getDefaultSku(), GetterUtil.getBoolean((Object)subscriptionConfiguration.getEnable()), GetterUtil.getInteger((Object)subscriptionConfiguration.getLength(), (int)1), GetterUtil.getString((String)subscriptionConfiguration.getSubscriptionTypeAsString()), null, GetterUtil.getLong((Object)subscriptionConfiguration.getNumberOfLength()), productStatus, serviceContext);
        if (product.getActive() != null && !product.getActive().booleanValue()) {
            HashMap workflowContext = new HashMap();
            this._cpDefinitionService.updateStatus(cpDefinition.getCPDefinitionId(), 5, serviceContext, workflowContext);
        }
        if ((expando = product.getExpando()) != null && !expando.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CPDefinition.class, (long)cpDefinition.getPrimaryKey(), (Map)expando);
        }
        this._updateNestedResources(product, cpDefinition, serviceContext);
        return cpDefinition;
    }

    private Map<String, Map<String, String>> _getActions(CPDefinition cpDefinition) {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", cpDefinition.getCPDefinitionId(), "deleteProduct", this._cpDefinitionModelResourcePermission)).put((Object)"get", this.addAction("VIEW", cpDefinition.getCPDefinitionId(), "getProduct", this._cpDefinitionModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", cpDefinition.getCPDefinitionId(), "patchProduct", this._cpDefinitionModelResourcePermission)).build();
    }

    private String[] _getAssetTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }

    private CPDefinition _getCPDefinition(CPDefinition cpDefinition, ServiceContext serviceContext) throws Exception {
        CProductVersionConfiguration cProductVersionConfiguration;
        if (!cpDefinition.isDraft() && serviceContext.getWorkflowAction() == 2 && (cProductVersionConfiguration = (CProductVersionConfiguration)this._configurationProvider.getConfiguration(CProductVersionConfiguration.class, (SettingsLocator)new SystemSettingsLocator(CProductVersionConfiguration.class.getName()))).enabled()) {
            List cProductCPDefinitions = this._cpDefinitionService.getCProductCPDefinitions(cpDefinition.getCProductId(), 2, -1, -1);
            for (CPDefinition cProductCPDefinition : cProductCPDefinitions) {
                this._cpDefinitionService.updateStatus(cProductCPDefinition.getCPDefinitionId(), 6, serviceContext, Collections.emptyMap());
            }
            cpDefinition = this._cpDefinitionService.copyCPDefinition(cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), 2);
        }
        return cpDefinition;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(Attachment attachment) {
        return CustomFieldsUtil.toMap(CPAttachmentFileEntry.class.getName(), this.contextCompany.getCompanyId(), attachment.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(Product product) {
        return CustomFieldsUtil.toMap(CPDefinition.class.getName(), this.contextCompany.getCompanyId(), product.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(Sku sku) {
        return CustomFieldsUtil.toMap(CPInstance.class.getName(), this.contextCompany.getCompanyId(), sku.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private ProductShippingConfiguration _getProductShippingConfiguration(Product product) {
        ProductShippingConfiguration shippingConfiguration = product.getShippingConfiguration();
        if (shippingConfiguration != null) {
            return shippingConfiguration;
        }
        return new ProductShippingConfiguration();
    }

    private ProductSubscriptionConfiguration _getProductSubscriptionConfiguration(Product product) {
        ProductSubscriptionConfiguration subscriptionConfiguration = product.getSubscriptionConfiguration();
        if (subscriptionConfiguration != null) {
            return subscriptionConfiguration;
        }
        return new ProductSubscriptionConfiguration();
    }

    private ProductTaxConfiguration _getProductTaxConfiguration(Product product) {
        ProductTaxConfiguration taxConfiguration = product.getTaxConfiguration();
        if (taxConfiguration != null) {
            return taxConfiguration;
        }
        return new ProductTaxConfiguration();
    }

    private Product _toProduct(Long cpDefinitionId) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpDefinitionId.longValue());
        return (Product)this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpDefinition), this._dtoConverterRegistry, (Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CPDefinition _updateNestedResources(Product product, CPDefinition cpDefinition, ServiceContext serviceContext) throws Exception {
        CPType cpType;
        Attachment[] attachments;
        Attachment[] images;
        Sku[] skus;
        RelatedProduct[] relatedProducts;
        ProductOption[] productOptions;
        ProductSpecification[] productSpecifications;
        ProductTaxConfiguration productTaxConfiguration;
        ProductSubscriptionConfiguration productSubscriptionConfiguration;
        ProductShippingConfiguration productShippingConfiguration;
        serviceContext.setExpandoBridgeAttributes(null);
        ProductConfiguration productConfiguration = product.getConfiguration();
        if (productConfiguration != null) {
            ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId());
        }
        if ((productShippingConfiguration = product.getShippingConfiguration()) != null) {
            cpDefinition = ProductShippingConfigurationUtil.updateCPDefinitionShippingInfo(this._cpDefinitionService, productShippingConfiguration, cpDefinition, serviceContext);
        }
        if ((productSubscriptionConfiguration = product.getSubscriptionConfiguration()) != null) {
            cpDefinition = ProductSubscriptionConfigurationUtil.updateCPDefinitionSubscriptionInfo(this._cpDefinitionService, productSubscriptionConfiguration, cpDefinition, serviceContext);
        }
        if ((productTaxConfiguration = product.getTaxConfiguration()) != null) {
            cpDefinition = ProductTaxConfigurationUtil.updateCPDefinitionTaxCategoryInfo(this._cpDefinitionService, productTaxConfiguration, cpDefinition);
        }
        if ((productSpecifications = product.getProductSpecifications()) != null) {
            this._cpDefinitionSpecificationOptionValueService.deleteCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId());
            for (ProductSpecification productSpecification : productSpecifications) {
                ProductSpecificationUtil.addCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, this._cpSpecificationOptionService, cpDefinition.getCPDefinitionId(), productSpecification, serviceContext);
            }
        }
        if ((productOptions = product.getProductOptions()) != null) {
            for (ProductOption productOption : productOptions) {
                CPDefinitionOptionRel cpDefinitionOptionRel = ProductOptionUtil.addOrUpdateCPDefinitionOptionRel(this._cpDefinitionOptionRelService, this._cpOptionService, productOption, cpDefinition.getCPDefinitionId(), serviceContext);
                ProductOptionValue[] productOptionValues = productOption.getProductOptionValues();
                if (productOptionValues == null) continue;
                for (ProductOptionValue productOptionValue : productOptionValues) {
                    ProductOptionValueUtil.addOrUpdateCPDefinitionOptionValueRel(this._cpDefinitionOptionValueRelService, productOptionValue, cpDefinitionOptionRel.getCPDefinitionOptionRelId(), serviceContext);
                }
            }
        }
        if ((relatedProducts = product.getRelatedProducts()) != null) {
            for (RelatedProduct relatedProduct : relatedProducts) {
                RelatedProductUtil.addOrUpdateCPDefinitionLink(this._cpDefinitionLinkService, this._cpDefinitionService, relatedProduct, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
            }
        }
        if ((skus = product.getSkus()) != null) {
            for (Sku sku : skus) {
                serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(sku));
                CPInstance cpInstance = SkuUtil.addOrUpdateCPInstance(this._cpInstanceService, sku, cpDefinition, serviceContext);
                serviceContext.setExpandoBridgeAttributes(null);
                SkuUtil.updateCommercePriceEntries(this._commercePriceEntryLocalService, this._commercePriceListLocalService, this._configurationProvider, cpInstance, (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)cpInstance.getPrice()), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)cpInstance.getPromoPrice()), serviceContext);
            }
        }
        if ((images = product.getImages()) != null) {
            for (Attachment attachment : images) {
                Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(attachment);
                if (expandoBridgeAttributes != null) {
                    serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
                }
                AttachmentUtil.addOrUpdateCPAttachmentFileEntry(cpDefinition.getGroupId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 0, serviceContext);
            }
        }
        if ((attachments = product.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(attachment);
                if (expandoBridgeAttributes != null) {
                    serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
                }
                AttachmentUtil.addOrUpdateCPAttachmentFileEntry(cpDefinition.getGroupId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 1, serviceContext);
            }
        }
        this._cpDefinitionService.updateCPDefinitionChannelFilter(cpDefinition.getCPDefinitionId(), GetterUtil.getBoolean((Object)product.getProductChannelFilter(), (boolean)cpDefinition.isChannelFilterEnabled()));
        ProductChannel[] productChannels = product.getProductChannels();
        if (productChannels != null) {
            this._commerceChannelRelService.deleteCommerceChannelRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
            Stream<ProductChannel> stream = Arrays.stream(productChannels);
            List channelIds = stream.map(productChannel -> {
                CommerceChannel commerceChannel;
                block4: {
                    if (productChannel.getExternalReferenceCode() == null) {
                        return productChannel.getChannelId();
                    }
                    commerceChannel = null;
                    try {
                        commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(productChannel.getExternalReferenceCode(), this.contextCompany.getCompanyId());
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) break block4;
                        _log.debug((Throwable)portalException);
                    }
                }
                if (commerceChannel == null) {
                    return null;
                }
                return commerceChannel.getCommerceChannelId();
            }).collect(Collectors.toList());
            for (Long commerceChannelId : channelIds) {
                if (commerceChannelId == null) continue;
                this._commerceChannelRelService.addCommerceChannelRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), commerceChannelId.longValue(), serviceContext);
            }
        }
        this._cpDefinitionService.updateCPDefinitionAccountGroupFilter(cpDefinition.getCPDefinitionId(), GetterUtil.getBoolean((Object)product.getProductAccountGroupFilter(), (boolean)cpDefinition.isAccountGroupFilterEnabled()));
        ProductAccountGroup[] productAccountGroups = product.getProductAccountGroups();
        if (productAccountGroups != null) {
            this._commerceAccountGroupRelService.deleteCommerceAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
            Stream<ProductAccountGroup> productAccountGroupStream = Arrays.stream(productAccountGroups);
            List accountGroupIds = productAccountGroupStream.map(productAccountGroup -> {
                CommerceAccountGroup commerceAccountGroup;
                block4: {
                    if (productAccountGroup.getExternalReferenceCode() == null) {
                        return productAccountGroup.getAccountGroupId();
                    }
                    commerceAccountGroup = null;
                    try {
                        commerceAccountGroup = this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), productAccountGroup.getExternalReferenceCode());
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) break block4;
                        _log.debug((Throwable)portalException);
                    }
                }
                if (commerceAccountGroup == null) {
                    return null;
                }
                return commerceAccountGroup.getCommerceAccountGroupId();
            }).collect(Collectors.toList());
            for (MappedProduct[] accountGroupId : accountGroupIds) {
                if (accountGroupId == null) continue;
                this._commerceAccountGroupRelService.addCommerceAccountGroupRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), accountGroupId.longValue(), serviceContext);
            }
        }
        if ((cpType = this._cpTypeRegistry.getCPType(cpDefinition.getProductTypeName())) != null && "diagram".equals(cpType.getName())) {
            Pin[] pins;
            MappedProduct[] mappedProducts;
            Diagram diagram = product.getDiagram();
            if (diagram != null) {
                DiagramUtil.addOrUpdateCSDiagramSetting(this.contextCompany.getCompanyId(), this._cpAttachmentFileEntryService, cpDefinition.getCPDefinitionId(), this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._csDiagramSettingService, diagram, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this._serviceContextHelper, this._uniqueFileNameProvider);
            }
            if ((mappedProducts = product.getMappedProducts()) != null) {
                this._csDiagramEntryService.deleteCSDiagramEntries(cpDefinition.getCPDefinitionId());
                for (MappedProduct mappedProduct : mappedProducts) {
                    MappedProductUtil.addOrUpdateCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
                }
            }
            if ((pins = product.getPins()) != null) {
                this._csDiagramPinService.deleteCSDiagramPins(cpDefinition.getCPDefinitionId());
                for (Pin pin : pins) {
                    PinUtil.addOrUpdateCSDiagramPin(cpDefinition.getCPDefinitionId(), this._csDiagramPinService, pin);
                }
            }
        }
        return cpDefinition;
    }

    private CPDefinition _updateProduct(CPDefinition cpDefinition, Product product) throws Exception {
        Map expando;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        int productStatus = GetterUtil.getInteger((Object)product.getProductStatus());
        if (productStatus == 2) {
            serviceContext.setWorkflowAction(2);
        }
        cpDefinition = this._getCPDefinition(cpDefinition, serviceContext);
        String[] assetTags = product.getTags();
        if (product.getTags() == null) {
            assetTags = this._getAssetTags(cpDefinition);
        }
        serviceContext.setAssetTagNames(assetTags);
        Map<String, Serializable> expandoBridgeAttributes = this._getExpandoBridgeAttributes(product);
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        Category[] categories = product.getCategories();
        if (categories == null) {
            serviceContext.setAssetCategoryIds(this._assetCategoryLocalService.getCategoryIds(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()));
        } else {
            ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
            for (Category category : categories) {
                if (category.getId() == null) continue;
                assetCategoryIds.add(category.getId());
            }
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray(assetCategoryIds));
        }
        Map nameMap = product.getName();
        if (cpDefinition != null && nameMap == null) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
        }
        Map shortDescriptionMap = product.getShortDescription();
        if (cpDefinition != null && shortDescriptionMap == null) {
            shortDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
        }
        Map descriptionMap = product.getDescription();
        if (cpDefinition != null && descriptionMap == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
        }
        Map urlTitleMap = product.getUrls();
        if (cpDefinition != null && urlTitleMap == null) {
            urlTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getUrlTitleMap());
        }
        Map metaTitleMap = product.getMetaTitle();
        if (cpDefinition != null && metaTitleMap == null) {
            metaTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
        }
        Map metaDescriptionMap = product.getMetaDescription();
        if (cpDefinition != null && metaDescriptionMap == null) {
            metaDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
        }
        Map metaKeywordsMap = product.getMetaKeyword();
        if (cpDefinition != null && metaKeywordsMap == null) {
            metaKeywordsMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
        }
        cpDefinition = this._cpDefinitionService.updateCPDefinition(cpDefinition.getCPDefinitionId(), LanguageUtils.getLocalizedMap((Map)nameMap), LanguageUtils.getLocalizedMap((Map)shortDescriptionMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), LanguageUtils.getLocalizedMap((Map)urlTitleMap), LanguageUtils.getLocalizedMap((Map)metaTitleMap), LanguageUtils.getLocalizedMap((Map)metaDescriptionMap), LanguageUtils.getLocalizedMap((Map)metaKeywordsMap), cpDefinition.isIgnoreSKUCombinations(), cpDefinition.getDDMStructureKey(), true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)product.getNeverExpire(), (boolean)true), serviceContext);
        if (product.getActive() != null && !product.getActive().booleanValue()) {
            HashMap workflowContext = new HashMap();
            this._cpDefinitionService.updateStatus(cpDefinition.getCPDefinitionId(), 5, serviceContext, workflowContext);
        }
        if ((expando = product.getExpando()) != null && !expando.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CPDefinition.class, (long)cpDefinition.getPrimaryKey(), (Map)expando);
        }
        return this._updateNestedResources(product, cpDefinition, serviceContext);
    }
}

