/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.CustomField;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.CustomValue;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Geo;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CustomFieldsUtil {
    public static CustomField[] toCustomFields(boolean acceptAllLanguages, String className, long classPK, long companyId, Locale locale) {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)className, (long)classPK);
        Map attributes = expandoBridge.getAttributes();
        return (CustomField[])TransformUtil.transformToArray(attributes.entrySet(), entry -> {
            UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties((String)entry.getKey());
            if (GetterUtil.getBoolean((String)unicodeProperties.getProperty("hidden"))) {
                return null;
            }
            return CustomFieldsUtil._toCustomField(acceptAllLanguages, entry, expandoBridge, locale);
        }, CustomField.class);
    }

    public static Map<String, Serializable> toMap(String className, long companyId, CustomField[] customFields, Locale locale) {
        if (customFields == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (CustomField customField : customFields) {
            map.put(customField.getName(), CustomFieldsUtil._getValue(className, companyId, locale, customField));
        }
        return map;
    }

    private static Map<String, String> _getLocalizedValues(boolean acceptAllLanguages, int attributeType, Object value) {
        if (20 != attributeType) {
            return null;
        }
        Map map = (Map)value;
        return LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)map);
    }

    private static Object _getValue(int attributeType, Locale locale, Object value) {
        if (20 == attributeType) {
            Map map = (Map)value;
            return map.get(locale);
        }
        if (3 == attributeType) {
            return DateUtil.getDate((Date)((Date)value), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Locale)locale, (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        return value;
    }

    private static Object _getValue(Map.Entry<String, Serializable> entry, ExpandoBridge expandoBridge, String key) {
        Serializable value = entry.getValue();
        if (CustomFieldsUtil._isEmpty(value)) {
            return expandoBridge.getAttributeDefault(key);
        }
        return value;
    }

    private static Serializable _getValue(String className, long companyId, Locale locale, CustomField customField) {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)className);
        int attributeType = expandoBridge.getAttributeType(customField.getName());
        CustomValue customValue = customField.getCustomValue();
        Object data = customValue.getData();
        if (3 == attributeType) {
            return CustomFieldsUtil._parseDate(String.valueOf(data));
        }
        if (6 == attributeType) {
            return ArrayUtil.toDoubleArray((Collection)((List)data));
        }
        if (8 == attributeType) {
            return ArrayUtil.toFloatArray((Collection)((List)data));
        }
        if (21 == attributeType) {
            Geo geo = customValue.getGeo();
            return JSONUtil.put((String)"latitude", (Object)geo.getLatitude()).put("longitude", (Object)geo.getLongitude()).toString();
        }
        if (10 == attributeType) {
            return ArrayUtil.toIntArray((Collection)((List)data));
        }
        if (12 == attributeType) {
            return ArrayUtil.toLongArray((Collection)((List)data));
        }
        if (16 == attributeType) {
            List list = (List)data;
            return list.toArray(new String[0]);
        }
        if (20 == attributeType) {
            return (Serializable)((Object)LocalizedMapUtil.getLocalizedMap((Locale)locale, (String)((String)data), (Map)customValue.getData_i18n()));
        }
        return (Serializable)data;
    }

    private static boolean _isEmpty(Object value) {
        Map map;
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray() && Array.getLength(value) == 0) {
            return true;
        }
        return value instanceof Map && (map = (Map)value).isEmpty();
    }

    private static Serializable _parseDate(String data) {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            return dateFormat.parse(data);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Unable to parse date from " + data, parseException);
        }
    }

    private static CustomField _toCustomField(final boolean acceptAllLanguages, final Map.Entry<String, Serializable> entry, final ExpandoBridge expandoBridge, final Locale locale) {
        final String key = entry.getKey();
        final int attributeType = expandoBridge.getAttributeType(key);
        if (21 == attributeType) {
            return new CustomField(){
                {
                    this.dataType = "Geolocation";
                    this.name = (String)entry.getKey();
                    this.setCustomValue(() -> {
                        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(entry.getValue()));
                        return new CustomValue(){
                            {
                                this.geo = new Geo(){
                                    {
                                        this.latitude = jsonObject.getDouble("latitude");
                                        this.longitude = jsonObject.getDouble("longitude");
                                    }
                                };
                            }
                        };
                    });
                }
            };
        }
        return new CustomField(){
            {
                this.customValue = new CustomValue(){
                    {
                        this.data = CustomFieldsUtil._getValue(attributeType, locale, CustomFieldsUtil._getValue(entry, expandoBridge, key));
                        this.data_i18n = CustomFieldsUtil._getLocalizedValues(acceptAllLanguages, attributeType, CustomFieldsUtil._getValue(entry, expandoBridge, key));
                    }
                };
                this.dataType = ExpandoColumnConstants.getDataType((int)attributeType);
                this.name = (String)entry.getKey();
            }
        };
    }
}

