/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramSetting;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Diagram;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseDiagramResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.DiagramUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.DiagramResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.upload.UniqueFileNameProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/diagram.properties"}, scope=ServiceScope.PROTOTYPE, service={DiagramResource.class, NestedFieldSupport.class})
public class DiagramResourceImpl
extends BaseDiagramResourceImpl
implements NestedFieldSupport {
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private CSDiagramSettingService _csDiagramSettingService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.DiagramDTOConverter)")
    private DTOConverter<CSDiagramSetting, Diagram> _diagramDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public Diagram getProductByExternalReferenceCodeDiagram(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramSetting csDiagramSetting = this._csDiagramSettingService.getCSDiagramSettingByCPDefinitionId(cpDefinition.getCPDefinitionId());
        return this._toDiagram(csDiagramSetting.getCSDiagramSettingId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="diagram")
    public Diagram getProductIdDiagram(Long productId) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramSetting csDiagramSetting = this._csDiagramSettingService.getCSDiagramSettingByCPDefinitionId(cpDefinition.getCPDefinitionId());
        return this._toDiagram(csDiagramSetting.getCSDiagramSettingId());
    }

    @Override
    public Diagram patchDiagram(Long diagramId, Diagram diagram) throws Exception {
        CSDiagramSetting csDiagramSetting = this._csDiagramSettingService.getCSDiagramSetting(diagramId.longValue());
        CPDefinition cpDefinition = csDiagramSetting.getCPDefinition();
        DiagramUtil.updateCSDiagramSetting(this.contextCompany.getCompanyId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, csDiagramSetting, this._csDiagramSettingService, diagram, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this._serviceContextHelper, this._uniqueFileNameProvider);
        return this._toDiagram(diagramId);
    }

    @Override
    public Diagram postProductByExternalReferenceCodeDiagram(String externalReferenceCode, Diagram diagram) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramSetting csDiagramSetting = DiagramUtil.addCSDiagramSetting(this.contextCompany.getCompanyId(), this._cpAttachmentFileEntryService, cpDefinition.getCPDefinitionId(), this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._csDiagramSettingService, diagram, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this._serviceContextHelper, this._uniqueFileNameProvider);
        return this._toDiagram(csDiagramSetting.getCSDiagramSettingId());
    }

    @Override
    public Diagram postProductIdDiagram(Long productId, Diagram diagram) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramSetting csDiagramSetting = DiagramUtil.addCSDiagramSetting(this.contextCompany.getCompanyId(), this._cpAttachmentFileEntryService, cpDefinition.getCPDefinitionId(), this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._csDiagramSettingService, diagram, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this._serviceContextHelper, this._uniqueFileNameProvider);
        return this._toDiagram(csDiagramSetting.getCSDiagramSettingId());
    }

    private Diagram _toDiagram(long csDiagramSettingId) throws Exception {
        return (Diagram)this._diagramDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)csDiagramSettingId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

