/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=com.liferay.commerce.product.model.CommerceCatalog",
	service = {CatalogDTOConverter.class, DTOConverter.class}
)
public class CatalogDTOConverter
	implements DTOConverter<CommerceCatalog, Catalog> {

	@Override
	public String getContentType() {
		return Catalog.class.getSimpleName();
	}

	@Override
	public Catalog toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CommerceCatalog commerceCatalog =
			_commerceCatalogService.getCommerceCatalog(
				(Long)dtoConverterContext.getId());

		return new Catalog() {
			{
				actions = dtoConverterContext.getActions();
				currencyCode = commerceCatalog.getCommerceCurrencyCode();
				defaultLanguageId =
					commerceCatalog.getCatalogDefaultLanguageId();
				externalReferenceCode =
					commerceCatalog.getExternalReferenceCode();
				id = commerceCatalog.getCommerceCatalogId();
				name = commerceCatalog.getName();
				system = commerceCatalog.isSystem();
			}
		};
	}

	@Reference
	private CommerceCatalogService _commerceCatalogService;

}