/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionSpecificationOptionValueException;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductSpecificationDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductSpecificationHelper;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductSpecificationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSpecificationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-specification.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ProductSpecificationResource.class})
public class ProductSpecificationResourceImpl
extends BaseProductSpecificationResourceImpl
implements NestedFieldSupport {
    private static final Log _log = LogFactoryUtil.getLog(ProductSpecificationResourceImpl.class);
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private ProductSpecificationDTOConverter _productSpecificationDTOConverter;
    @Reference
    private ProductSpecificationHelper _productSpecificationHelper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteProductSpecification(Long id) throws Exception {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(id.longValue());
        this._cpDefinitionSpecificationOptionValueService.deleteCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="productSpecifications")
    public Page<ProductSpecification> getProductIdProductSpecificationsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        return this._productSpecificationHelper.getProductSpecificationsPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public ProductSpecification getProductSpecification(Long id) throws Exception {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(id.longValue());
        return this._toProductSpecification(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
    }

    @Override
    public ProductSpecification patchProductSpecification(Long id, ProductSpecification productSpecification) throws Exception {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._updateProductSpecification(id, productSpecification);
        return this._toProductSpecification(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
    }

    @Override
    public ProductSpecification postProductIdProductSpecification(Long id, ProductSpecification productSpecification) throws Exception {
        return this._addOrUpdateProductSpecification(id, productSpecification);
    }

    private ProductSpecification _addOrUpdateProductSpecification(Long id, ProductSpecification productSpecification) throws Exception {
        block3: {
            Long productSpecificationId = productSpecification.getId();
            if (productSpecificationId != null) {
                try {
                    CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._updateProductSpecification(productSpecificationId, productSpecification);
                    return this._toProductSpecification(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
                }
                catch (NoSuchCPDefinitionSpecificationOptionValueException noSuchCPDefinitionSpecificationOptionValueException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)("Unable to find productSpecification with ID: " + productSpecificationId), (Throwable)noSuchCPDefinitionSpecificationOptionValueException);
                }
            }
        }
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = ProductSpecificationUtil.addCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, this._cpSpecificationOptionService, id, productSpecification, this._serviceContextHelper.getServiceContext());
        return this._toProductSpecification(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
    }

    private ProductSpecification _toProductSpecification(Long cpDefinitionSpecificationOptionValueId) throws Exception {
        return this._productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionSpecificationOptionValueId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CPDefinitionSpecificationOptionValue _updateProductSpecification(Long id, ProductSpecification productSpecification) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(id.longValue());
        return ProductSpecificationUtil.updateCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, cpDefinitionSpecificationOptionValue, this._cpSpecificationOptionService, productSpecification, this._serviceContextHelper.getServiceContext());
    }
}

