/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuDTOConverter;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SkuHelper.class})
public class SkuHelper {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private SkuDTOConverter _skuDTOConverter;

    public Page<Sku> getSkusPage(long id, Locale locale, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id);
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        List cpInstances = this._cpInstanceService.getCPDefinitionInstances(cpDefinition.getCPDefinitionId(), 0, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpInstanceService.getCPDefinitionInstancesCount(cpDefinition.getCPDefinitionId(), 0);
        return Page.of(this.toSKUs(cpInstances, locale), (Pagination)pagination, (long)totalItems);
    }

    public Page<Sku> getSkusPage(final long companyId, String search, Filter filter, Pagination pagination, Sort[] sorts, UnsafeFunction<Document, Sku, Exception> transformUnsafeFunction) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPInstance.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setCompanyId(companyId);
            }
        }, (Sort[])sorts, transformUnsafeFunction);
    }

    public List<Sku> toSKUs(List<CPInstance> cpInstances, Locale locale) throws Exception {
        ArrayList<Sku> skus = new ArrayList<Sku>();
        for (CPInstance cpInstance : cpInstances) {
            skus.add(this._skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstance.getCPInstanceId(), locale)));
        }
        return skus;
    }
}

