/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=com.liferay.commerce.model.CPDefinitionInventory",
	service = {DTOConverter.class, ProductConfigurationDTOConverter.class}
)
public class ProductConfigurationDTOConverter
	implements DTOConverter<CPDefinitionInventory, ProductConfiguration> {

	@Override
	public String getContentType() {
		return ProductConfiguration.class.getSimpleName();
	}

	@Override
	public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CPDefinitionInventory cpDefinitionInventory =
			_cpDefinitionInventoryService.
				fetchCPDefinitionInventoryByCPDefinitionId(
					(Long)dtoConverterContext.getId());

		if (cpDefinitionInventory == null) {
			return new ProductConfiguration();
		}

		return new ProductConfiguration() {
			{
				allowBackOrder = cpDefinitionInventory.isBackOrders();
				allowedOrderQuantities = ArrayUtil.toArray(
					cpDefinitionInventory.getAllowedOrderQuantitiesArray());
				inventoryEngine =
					cpDefinitionInventory.getCPDefinitionInventoryEngine();
				maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
				minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
				multipleOrderQuantity =
					cpDefinitionInventory.getMultipleOrderQuantity();
			}
		};
	}

	@Reference
	private CPDefinitionInventoryService _cpDefinitionInventoryService;

}