/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.grouped.model.CPDefinitionGroupedEntry;
import com.liferay.commerce.product.type.grouped.service.CPDefinitionGroupedEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.GroupedProduct;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.GroupedProductDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseGroupedProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.GroupedProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/grouped-product.properties"}, scope=ServiceScope.PROTOTYPE, service={GroupedProductResource.class})
public class GroupedProductResourceImpl
extends BaseGroupedProductResourceImpl {
    @Reference
    private CPDefinitionGroupedEntryService _cpDefinitionGroupedEntryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupedProductDTOConverter _groupedProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteGroupedProduct(Long groupedProductId) throws Exception {
        this._cpDefinitionGroupedEntryService.deleteCPDefinitionGroupedEntry(groupedProductId.longValue());
    }

    @Override
    public Page<GroupedProduct> getProductByExternalReferenceCodeGroupedProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find grouped product with external reference code " + externalReferenceCode);
        }
        return this._getGroupedProductsPage(cpDefinition.getCPDefinitionId(), pagination);
    }

    @Override
    public Page<GroupedProduct> getProductIdGroupedProductsPage(Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find grouped product with ID " + productId);
        }
        return this._getGroupedProductsPage(cpDefinition.getCPDefinitionId(), pagination);
    }

    @Override
    public GroupedProduct patchGroupedProduct(Long groupedProductId, GroupedProduct groupedProduct) throws Exception {
        CPDefinitionGroupedEntry cpDefinitionGroupedEntry = this._cpDefinitionGroupedEntryService.getCPDefinitionGroupedEntry(groupedProductId.longValue());
        cpDefinitionGroupedEntry = this._cpDefinitionGroupedEntryService.updateCPDefinitionGroupedEntry(cpDefinitionGroupedEntry.getCPDefinitionGroupedEntryId(), GetterUtil.getDouble((Object)groupedProduct.getPriority(), (double)cpDefinitionGroupedEntry.getPriority()), GetterUtil.getInteger((Object)groupedProduct.getQuantity(), (int)cpDefinitionGroupedEntry.getQuantity()));
        return this._toGroupedProduct(cpDefinitionGroupedEntry.getCPDefinitionGroupedEntryId());
    }

    @Override
    public GroupedProduct postProductByExternalReferenceCodeGroupedProduct(String externalReferenceCode, GroupedProduct groupedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find grouped product with external reference code " + externalReferenceCode);
        }
        CPDefinitionGroupedEntry cpDefinitionGroupedEntry = this._addCPDefinitionGroupedEntry(cpDefinition, groupedProduct);
        return this._toGroupedProduct(cpDefinitionGroupedEntry.getCPDefinitionGroupedEntryId());
    }

    @Override
    public GroupedProduct postProductIdGroupedProduct(Long productId, GroupedProduct groupedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find grouped product with ID " + productId);
        }
        CPDefinitionGroupedEntry cpDefinitionGroupedEntry = this._addCPDefinitionGroupedEntry(cpDefinition, groupedProduct);
        return this._toGroupedProduct(cpDefinitionGroupedEntry.getCPDefinitionGroupedEntryId());
    }

    private CPDefinitionGroupedEntry _addCPDefinitionGroupedEntry(CPDefinition cpDefinition, GroupedProduct groupedProduct) throws Exception {
        CPDefinition entryCPDefinition = null;
        if (Validator.isNotNull((String)groupedProduct.getEntryProductExternalReferenceCode())) {
            entryCPDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(groupedProduct.getEntryProductExternalReferenceCode(), this.contextCompany.getCompanyId());
        }
        if (entryCPDefinition == null) {
            entryCPDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(groupedProduct.getEntryProductId().longValue());
        }
        if (entryCPDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find entry product with ID " + groupedProduct.getEntryProductId());
        }
        return this._cpDefinitionGroupedEntryService.addCPDefinitionGroupedEntry(cpDefinition.getCPDefinitionId(), entryCPDefinition.getCProductId(), GetterUtil.getDouble((Object)groupedProduct.getPriority()), GetterUtil.getInteger((Object)groupedProduct.getQuantity()), this._serviceContextHelper.getServiceContext(this.contextUser));
    }

    private Page<GroupedProduct> _getGroupedProductsPage(long cpDefinitionId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._cpDefinitionGroupedEntryService.getCPDefinitionGroupedEntries(cpDefinitionId, pagination.getStartPosition(), pagination.getEndPosition(), null), cpDefinitionGroupedEntry -> this._toGroupedProduct(cpDefinitionGroupedEntry.getCPDefinitionGroupedEntryId())), (Pagination)pagination, (long)this._cpDefinitionGroupedEntryService.getCPDefinitionGroupedEntriesCount(cpDefinitionId));
    }

    private GroupedProduct _toGroupedProduct(long cpDefinitionGroupedEntryId) throws Exception {
        return this._groupedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, (Object)cpDefinitionGroupedEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

