/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroup;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.pricing.model.CommercePricingClass"}, service={DTOConverter.class, ProductGroupDTOConverter.class})
public class ProductGroupDTOConverter
implements DTOConverter<CommercePricingClass, ProductGroup> {
    @Reference
    private CommercePricingClassCPDefinitionRelService _commercePricingClassCPDefinitionRelService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;

    public String getContentType() {
        return ProductGroup.class.getSimpleName();
    }

    public ProductGroup toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommercePricingClass commercePricingClass = this._commercePricingClassService.getCommercePricingClass(((Long)dtoConverterContext.getId()).longValue());
        final ExpandoBridge expandoBridge = commercePricingClass.getExpandoBridge();
        return new ProductGroup(){
            {
                this.customFields = expandoBridge.getAttributes();
                this.description = LanguageUtils.getLanguageIdMap((Map)commercePricingClass.getDescriptionMap());
                this.externalReferenceCode = commercePricingClass.getExternalReferenceCode();
                this.id = commercePricingClass.getCommercePricingClassId();
                this.productsCount = ProductGroupDTOConverter.this._getProductsCount(commercePricingClass.getCommercePricingClassId());
                this.title = LanguageUtils.getLanguageIdMap((Map)commercePricingClass.getTitleMap());
            }
        };
    }

    private int _getProductsCount(long commercePricingClassId) throws Exception {
        return this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRelsCount(commercePricingClassId);
    }
}

