/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "dto.class.name=com.liferay.commerce.product.model.CPOption",
	service = {DTOConverter.class, OptionDTOConverter.class}
)
public class OptionDTOConverter implements DTOConverter<CPOption, Option> {

	@Override
	public String getContentType() {
		return Option.class.getSimpleName();
	}

	@Override
	public Option toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CPOption cpOption = _cpOptionService.getCPOption(
			(Long)dtoConverterContext.getId());

		return new Option() {
			{
				actions = dtoConverterContext.getActions();
				description = LanguageUtils.getLanguageIdMap(
					cpOption.getDescriptionMap());
				externalReferenceCode = cpOption.getExternalReferenceCode();
				facetable = cpOption.isFacetable();
				fieldType = Option.FieldType.create(
					cpOption.getDDMFormFieldTypeName());
				id = cpOption.getCPOptionId();
				key = cpOption.getKey();
				name = LanguageUtils.getLanguageIdMap(cpOption.getNameMap());
				required = cpOption.isRequired();
				skuContributor = cpOption.isSkuContributor();
			}
		};
	}

	@Reference
	private CPOptionService _cpOptionService;

}