/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.model.CommerceAccountGroupRel;
import com.liferay.commerce.account.service.CommerceAccountGroupRelService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductAccountGroup;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductAccountGroupResource;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ProductAccountGroupResource.class})
public class ProductAccountGroupResourceImpl
extends BaseProductAccountGroupResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountGroupRelService _commerceAccountGroupRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    @Override
    public void deleteProductAccountGroup(Long id) throws Exception {
        this._commerceAccountGroupRelService.deleteCommerceAccountGroupRel(id.longValue());
    }

    @Override
    public ProductAccountGroup getProductAccountGroup(Long id) throws Exception {
        return this.toProductAccountGroup(this._commerceAccountGroupRelService.getCommerceAccountGroupRel(id.longValue()));
    }

    @Override
    public Page<ProductAccountGroup> getProductByExternalReferenceCodeProductAccountGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of((Collection)TransformUtil.transform((Collection)this._commerceAccountGroupRelService.getCommerceAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::toProductAccountGroup), (Pagination)pagination, (long)this._commerceAccountGroupRelService.getCommerceAccountGroupRelsCount(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    @NestedField(parentClass=Product.class, value="productAccountGroups")
    public Page<ProductAccountGroup> getProductIdProductAccountGroupsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of((Collection)TransformUtil.transform((Collection)this._commerceAccountGroupRelService.getCommerceAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::toProductAccountGroup), (Pagination)pagination, (long)this._commerceAccountGroupRelService.getCommerceAccountGroupRelsCount(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId()));
    }

    public ProductAccountGroup toProductAccountGroup(final CommerceAccountGroupRel commerceAccountGroupRel) throws Exception {
        final CommerceAccountGroup commerceAccountGroup = commerceAccountGroupRel.getCommerceAccountGroup();
        return new ProductAccountGroup(){
            {
                this.accountGroupId = commerceAccountGroupRel.getCommerceAccountGroupId();
                this.externalReferenceCode = commerceAccountGroup.getExternalReferenceCode();
                this.id = commerceAccountGroupRel.getCommerceAccountGroupRelId();
                this.name = commerceAccountGroup.getName();
            }
        };
    }
}

