/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductChannel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ProductChannelHelper.class})
public class ProductChannelHelper {
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;

    public Page<ProductChannel> getProductChannelsPage(long id, Pagination pagination) throws Exception {
        int commerceChannelRelsCount = this._commerceChannelRelService.getCommerceChannelRelsCount(CPDefinition.class.getName(), id);
        return Page.of((Collection)TransformUtil.transform((Collection)this._commerceChannelRelService.getCommerceChannelRels(CPDefinition.class.getName(), id, null, pagination.getStartPosition(), pagination.getEndPosition()), this::toProductChannel), (Pagination)pagination, (long)commerceChannelRelsCount);
    }

    public ProductChannel toProductChannel(final CommerceChannelRel commerceChannelRel) throws Exception {
        final CommerceChannel commerceChannel = commerceChannelRel.getCommerceChannel();
        return new ProductChannel(){
            {
                this.channelId = commerceChannel.getCommerceChannelId();
                this.currencyCode = commerceChannel.getCommerceCurrencyCode();
                this.externalReferenceCode = commerceChannel.getExternalReferenceCode();
                this.id = commerceChannelRel.getCommerceChannelRelId();
                this.name = commerceChannel.getName();
                this.type = commerceChannel.getType();
            }
        };
    }
}

