/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeServicesTracker;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPTypeServicesTracker _cpTypeServicesTracker;
    @Reference
    private Language _language;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        final CProduct cProduct = cpDefinition.getCProduct();
        final ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
        final Locale locale = dtoConverterContext.getLocale();
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        final String productStatusLabel = WorkflowConstants.getStatusLabel((int)cpDefinition.getStatus());
        final String productStatusLabelI18n = this._language.get(resourceBundle, WorkflowConstants.getStatusLabel((int)cpDefinition.getStatus()));
        final CPType cpType = this._getCPType(cpDefinition.getProductTypeName());
        return new Product(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = !cpDefinition.isInactive();
                this.catalogId = ProductDTOConverter.this._getCommerceCatalogId(cpDefinition);
                this.categories = (Category[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._assetCategoryLocalService.getCategories(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()), assetCategory -> ProductDTOConverter.this._toCategory(assetCategory), Category.class);
                this.createDate = cpDefinition.getCreateDate();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), cpDefinition.getCompanyId(), dtoConverterContext.getLocale());
                this.description = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
                this.displayDate = cpDefinition.getDisplayDate();
                this.expando = expandoBridge.getAttributes();
                this.expirationDate = cpDefinition.getExpirationDate();
                this.externalReferenceCode = cProduct.getExternalReferenceCode();
                this.id = cpDefinition.getCPDefinitionId();
                this.metaDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
                this.metaKeyword = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
                this.metaTitle = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
                this.modifiedDate = cpDefinition.getModifiedDate();
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.productAccountGroupFilter = cpDefinition.isAccountGroupFilterEnabled();
                this.productChannelFilter = cpDefinition.isChannelFilterEnabled();
                this.productId = cProduct.getCProductId();
                this.productStatus = cpDefinition.getStatus();
                this.productType = cpType.getName();
                this.productTypeI18n = cpType.getLabel(locale);
                this.shortDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
                this.skuFormatted = ProductDTOConverter.this._getSku(cpDefinition, dtoConverterContext.getLocale());
                this.tags = ProductDTOConverter.this._getTags(cpDefinition);
                this.thumbnail = cpDefinition.getDefaultImageThumbnailSrc(Long.MIN_VALUE);
                this.urls = LanguageUtils.getLanguageIdMap((Map)ProductDTOConverter.this._cpDefinitionService.getUrlTitleMap(cpDefinition.getCPDefinitionId()));
                this.version = cpDefinition.getVersion();
                this.workflowStatusInfo = ProductDTOConverter.this._toStatus(cpDefinition.getStatus(), productStatusLabel, productStatusLabelI18n);
            }
        };
    }

    private long _getCommerceCatalogId(CPDefinition cpDefinition) {
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    private CPType _getCPType(String name) {
        return this._cpTypeServicesTracker.getCPType(name);
    }

    private String _getSku(CPDefinition cpDefinition, Locale locale) {
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            return "";
        }
        if (cpInstances.size() > 1) {
            return this._language.get(locale, "multiple-skus");
        }
        CPInstance cpInstance = (CPInstance)cpInstances.get(0);
        return cpInstance.getSku();
    }

    private String[] _getTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }

    private Category _toCategory(final AssetCategory assetCategory) {
        return new Category(){
            {
                this.externalReferenceCode = assetCategory.getExternalReferenceCode();
                this.id = assetCategory.getCategoryId();
                this.name = assetCategory.getName();
                this.setVocabulary(() -> {
                    AssetVocabulary assetVocabulary = ProductDTOConverter.this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
                    if (assetVocabulary == null) {
                        return null;
                    }
                    return assetVocabulary.getName();
                });
            }
        };
    }

    private Status _toStatus(final int statusCode, final String productStatusLabel, final String productStatusLabelI18n) {
        return new Status(){
            {
                this.code = statusCode;
                this.label = productStatusLabel;
                this.label_i18n = productStatusLabelI18n;
            }
        };
    }
}

