/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;

/**
 * @author Alessio Antonio Rendina
 */
public class ProductSubscriptionConfigurationUtil {

	public static CPDefinition updateCPDefinitionSubscriptionInfo(
			CPDefinitionService cpDefinitionService,
			ProductSubscriptionConfiguration productSubscriptionConfiguration,
			CPDefinition cpDefinition, ServiceContext serviceContext)
		throws PortalException {

		String subscriptionTypeValue = null;

		ProductSubscriptionConfiguration.SubscriptionType subscriptionType =
			productSubscriptionConfiguration.getSubscriptionType();

		if (subscriptionType != null) {
			subscriptionTypeValue = subscriptionType.getValue();
		}

		return cpDefinitionService.updateSubscriptionInfo(
			cpDefinition.getCPDefinitionId(),
			GetterUtil.get(
				productSubscriptionConfiguration.getEnable(),
				cpDefinition.isSubscriptionEnabled()),
			GetterUtil.get(
				productSubscriptionConfiguration.getLength(),
				cpDefinition.getSubscriptionLength()),
			subscriptionTypeValue,
			UnicodePropertiesBuilder.create(
				productSubscriptionConfiguration.getSubscriptionTypeSettings(),
				true
			).build(),
			GetterUtil.get(
				productSubscriptionConfiguration.getNumberOfLength(),
				cpDefinition.getMaxSubscriptionCycles()),
			serviceContext);
	}

}