/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Pin;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;

/**
 * @author Alessio Antonio Rendina
 */
public class PinUtil {

	public static CSDiagramPin addCSDiagramPin(
			long cpDefinitionId, CSDiagramPinService csDiagramPinService,
			Pin pin)
		throws PortalException {

		return csDiagramPinService.addCSDiagramPin(
			cpDefinitionId, GetterUtil.getDouble(pin.getPositionX()),
			GetterUtil.getDouble(pin.getPositionY()),
			GetterUtil.getString(pin.getSequence()));
	}

	public static CSDiagramPin addOrUpdateCSDiagramPin(
			long cpDefinitionId, CSDiagramPinService csDiagramPinService,
			Pin pin)
		throws PortalException {

		CSDiagramPin csDiagramPin = csDiagramPinService.fetchCSDiagramPin(
			cpDefinitionId);

		if (csDiagramPin == null) {
			return addCSDiagramPin(cpDefinitionId, csDiagramPinService, pin);
		}

		return updateCSDiagramPin(csDiagramPin, csDiagramPinService, pin);
	}

	public static CSDiagramPin updateCSDiagramPin(
			CSDiagramPin csDiagramPin, CSDiagramPinService csDiagramPinService,
			Pin pin)
		throws PortalException {

		return csDiagramPinService.updateCSDiagramPin(
			csDiagramPin.getCSDiagramPinId(),
			GetterUtil.get(pin.getPositionX(), csDiagramPin.getPositionX()),
			GetterUtil.get(pin.getPositionY(), csDiagramPin.getPositionY()),
			GetterUtil.get(pin.getSequence(), csDiagramPin.getSequence()));
	}

}